/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xdas4j.logger;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.codehaus.xdas4j.datamodel.XDASEvent;

public class XDASKeyValueLayout
extends Layout {
    private static final int DEFAULT_SIZE = 256;
    public static final String DEFAULT_KEYVALUE_SEPARATOR = "=";
    private static final String DEFAULT_KEY_SEPARATOR = ".";
    private static final String DEFAULT_PAIRS_SEPARATOR = ";";
    private StringBuffer sBuffer = new StringBuffer(256);
    private String pairsSeparator = ";";
    private String logHeader = null;

    public String getSeparator() {
        return this.pairsSeparator;
    }

    public void setSeparator(String separator) {
        this.pairsSeparator = separator;
    }

    public void setLogHeader(String logHeader) {
        this.logHeader = logHeader;
    }

    public String getLogHeader() {
        return this.logHeader;
    }

    public String format(LoggingEvent event) {
        XDASEvent evt = (XDASEvent)event.getMessage();
        this.sBuffer.setLength(0);
        if (this.logHeader != null) {
            this.sBuffer.append(this.logHeader);
        }
        this.keyValueFormat(null, evt);
        if (this.sBuffer.length() > this.pairsSeparator.length()) {
            this.sBuffer.delete(this.sBuffer.length() - this.pairsSeparator.length(), this.sBuffer.length());
        }
        return this.sBuffer.toString();
    }

    private void buildKeyValue(String parentKey, String key, String value) {
        if (parentKey != null) {
            this.sBuffer.append(parentKey);
            this.sBuffer.append(DEFAULT_KEY_SEPARATOR);
        }
        this.sBuffer.append(key);
        this.sBuffer.append(DEFAULT_KEYVALUE_SEPARATOR);
        this.sBuffer.append(value);
        this.sBuffer.append(this.pairsSeparator);
    }

    private void keyValueFormat(String parentKey, Object o) {
        Method[] eventMethods;
        for (Method m : eventMethods = o.getClass().getMethods()) {
            if (!m.getName().startsWith("get") || m.getName().contains("Instance") || m.getName().contains("Class")) continue;
            Object attributeData = null;
            try {
                attributeData = m.invoke(o, new Object[0]);
            }
            catch (Throwable e) {
                LogLog.error((String)("Unable to extract XDAS " + m.getName() + "attribute from " + o.getClass()), (Throwable)e);
            }
            if (attributeData == null) continue;
            if (!attributeData.getClass().getName().startsWith("org.codehaus.xdas4j.datamodel") || attributeData instanceof Enum) {
                if (attributeData instanceof Collection) {
                    Collection attributeCollection = (Collection)attributeData;
                    for (Object collectionItem : attributeCollection) {
                        this.keyValueFormat((parentKey == null ? "" : parentKey + DEFAULT_KEY_SEPARATOR) + collectionItem.getClass().getSimpleName(), collectionItem);
                    }
                    continue;
                }
                this.buildKeyValue(parentKey, m.getName().substring(3), attributeData.toString());
                continue;
            }
            this.keyValueFormat((parentKey == null ? "" : parentKey + DEFAULT_KEY_SEPARATOR) + attributeData.getClass().getSimpleName(), attributeData);
        }
    }

    public boolean ignoresThrowable() {
        return true;
    }

    public void activateOptions() {
    }
}

