package org.xdoclet.plugin.jdo.qtags;

public class JdoClassTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.jdo.qtags.JdoClassTag {
    public static final String NAME = "jdo.class";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"detachable",
		"embedded-only",
		"objectid-class",
		"persistence-modifier",
		"requires-extent",
		"table",
		"identity-type",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public JdoClassTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public JdoClassTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.Boolean getDetachable() {
		boolean required = false;
        String result = getNamedParameter("detachable");
        if(required && result == null) {
            bomb("detachable=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.Boolean getEmbeddedOnly() {
		boolean required = false;
        String result = getNamedParameter("embedded-only");
        if(required && result == null) {
            bomb("embedded-only=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getObjectidClass() {
		boolean required = false;
        String result = getNamedParameter("objectid-class");
        if(required && result == null) {
            bomb("objectid-class=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getPersistenceModifier() {
		boolean required = false;
        String result = getNamedParameter("persistence-modifier");
        if(required && result == null) {
            bomb("persistence-modifier=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            if( !(false || result.equals("persistence-capable")|| result.equals("persistence-aware")|| result.equals("non-persistent")) ) {
	                // todo we should say what file and line number too
	                bomb("persistence-modifier=\"" + result + "\" is an invalid parameter value.");
	            }
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getRequiresExtent() {
		boolean required = false;
        String result = getNamedParameter("requires-extent");
        if(required && result == null) {
            bomb("requires-extent=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getTable() {
		boolean required = false;
        String result = getNamedParameter("table");
        if(required && result == null) {
            bomb("table=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getIdentityType() {
		boolean required = false;
        String result = getNamedParameter("identity-type");
        if(required && result == null) {
            bomb("identity-type=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            if( !(false || result.equals("application")|| result.equals("datastore")|| result.equals("nondurable")) ) {
	                // todo we should say what file and line number too
	                bomb("identity-type=\"" + result + "\" is an invalid parameter value.");
	            }
	            retVal = result;
		}
		
		return retVal;
    }

    protected void validateLocation() {
        if(isOnField) {
            bomb("is not allowed on fields");
        }
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
		if(isOnMethod) {
        	bomb("is not allowed on methods");
		}
        
        // check uniqueness
        // deprecated here. check validateModel
		if(((com.thoughtworks.qdox.model.AbstractJavaEntity)getContext()).getTagsByName(NAME).length > 1) {
			bomb("is allowed only once");
		}

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getDetachable();
        getEmbeddedOnly();
        getObjectidClass();
        getPersistenceModifier();
        getRequiresExtent();
        getTable();
        getIdentityType();
    }

    public void validateModel() {
        // check uniqueness
        if(((com.thoughtworks.qdox.model.AbstractJavaEntity)getContext()).getTagsByName(NAME).length > 1) {
            bomb("is allowed only once");
        }
    }
}