/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.mapper;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codejargon.fluentjdbc.api.query.Mapper;

public abstract class Mappers {
    private static final Mapper<Integer> singleInteger = resultSet -> resultSet.getInt(1);
    private static final Mapper<Long> singleLong = resultSet -> resultSet.getLong(1);
    private static final Mapper<String> singleString = resultSet -> resultSet.getString(1);
    private static final Mapper<BigDecimal> singleBigDecimal = resultSet -> resultSet.getBigDecimal(1);
    private static final Mapper<Boolean> singleBoolean = resultSet -> resultSet.getBoolean(1);
    private static final Mapper<Map<String, Object>> map = resultSet -> {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(resultSetMetaData.getColumnCount());
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            linkedHashMap.put(resultSetMetaData.getColumnLabel(i), resultSet.getObject(i));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    };
    private static final Mapper<byte[]> singleByteArray = resultSet -> {
        Blob blob = resultSet.getBlob(1);
        return blob.getBytes(1L, (int)blob.length());
    };

    public static Mapper<Integer> singleInteger() {
        return singleInteger;
    }

    public static Mapper<Long> singleLong() {
        return singleLong;
    }

    public static Mapper<String> singleString() {
        return singleString;
    }

    public static Mapper<BigDecimal> singleBigDecimal() {
        return singleBigDecimal;
    }

    public static Mapper<Boolean> singleBoolean() {
        return singleBoolean;
    }

    public static Mapper<Map<String, Object>> map() {
        return map;
    }

    public static Mapper<byte[]> singleByteArray() {
        return singleByteArray;
    }
}

