/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codelabor.system.mime.service;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

/**
 * 마임타입 탐지 서비스 인터페이스
 * 
 * @author Shin Sang-jae
 * 
 */
public interface MimeDetectService {
	/**
	 * 마임타입을 가져온다.
	 * 
	 * @param inputStream
	 *            입력 스트림
	 * @return 마임타입
	 */
	public String getMimeType(InputStream inputStream) throws Exception;

	/**
	 * 마임타입을 가져온다.
	 * 
	 * @param file
	 *            파일
	 * @return 마임타입
	 */
	public String getMimeType(File file) throws Exception;

	/**
	 * 마임타입을 가져온다.
	 * 
	 * @param url
	 *            URL
	 * @return 마임타입
	 */
	public String getMimeType(URL url) throws Exception;

	/**
	 * 마임타입을 가져온다.
	 * 
	 * @param byteArray
	 *            바이트 배열
	 * @return 마임타입
	 */
	public String getMimeType(byte[] byteArray) throws Exception;

	/**
	 * 마임타입을 가져온다.
	 * 
	 * @param path
	 *            파일 경로
	 * @return 마임타입
	 */
	public String getMimeType(String path) throws Exception;
}
