/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public abstract class BufferedCharFilter
extends BaseCharFilter {
    protected Reader bufferedInput = null;

    public BufferedCharFilter(Reader in) {
        super(in);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.bufferedInput == null) {
            this.fill();
        }
        return this.bufferedInput.read(cbuf, off, len);
    }

    private void fill() throws IOException {
        StringBuilder buffered = new StringBuilder();
        char[] temp = new char[1024];
        int cnt = this.input.read(temp);
        while (cnt > 0) {
            buffered.append(temp, 0, cnt);
            cnt = this.input.read(temp);
        }
        this.bufferedInput = new StringReader(this.processInput(buffered).toString());
    }

    protected abstract CharSequence processInput(CharSequence var1);
}

