/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.en;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.codelibs.analysis.en.FlexiblePorterStemmer;

public class FlexiblePorterStemFilter
extends TokenFilter {
    private final FlexiblePorterStemmer stemmer;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    public FlexiblePorterStemFilter(TokenStream in, boolean step1, boolean step2, boolean step3, boolean step4, boolean step5, boolean step6) {
        super(in);
        this.stemmer = new FlexiblePorterStemmer(step1, step2, step3, step4, step5, step6);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (!this.keywordAttr.isKeyword() && this.stemmer.stem(this.termAtt.buffer(), 0, this.termAtt.length())) {
            this.termAtt.copyBuffer(this.stemmer.getResultBuffer(), 0, this.stemmer.getResultLength());
        }
        return true;
    }
}

