/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.en;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.miscellaneous.KeywordMarkerFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class ReloadableKeywordMarkerFilter
extends KeywordMarkerFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private CharArraySet keywordSet;
    private final Path keywordPath;
    private long reloadInterval;
    private long expiry;
    private long lastModifed;

    public ReloadableKeywordMarkerFilter(TokenStream in, Path keywordPath, long reloadInterval) {
        super(in);
        this.keywordPath = keywordPath;
        this.reloadInterval = reloadInterval;
        this.loadKeywordSet();
        this.expiry = System.currentTimeMillis() + reloadInterval;
    }

    protected boolean isKeyword() {
        return this.keywordSet.contains(this.termAtt.buffer(), 0, this.termAtt.length());
    }

    public void reset() throws IOException {
        if (this.expiry < System.currentTimeMillis()) {
            if (Files.getLastModifiedTime(this.keywordPath, new LinkOption[0]).toMillis() > this.lastModifed) {
                this.loadKeywordSet();
            }
            this.expiry = System.currentTimeMillis() + this.reloadInterval;
        }
        super.reset();
    }

    private void loadKeywordSet() {
        try (BufferedReader reader = Files.newBufferedReader(this.keywordPath, Charset.forName("UTF-8"));){
            this.keywordSet = WordlistLoader.getWordSet((Reader)reader);
            this.lastModifed = Files.getLastModifiedTime(this.keywordPath, new LinkOption[0]).toMillis();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read " + this.keywordPath, e);
        }
    }
}

