/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class CharTypeFilter
extends FilteringTokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private boolean alphabetic;
    private boolean digit;
    private boolean letter;

    public CharTypeFilter(TokenStream in, boolean alphabetic, boolean digit, boolean letter) {
        super(in);
        this.alphabetic = alphabetic;
        this.digit = digit;
        this.letter = letter;
    }

    protected boolean accept() throws IOException {
        for (int i = 0; i < this.termAtt.length(); ++i) {
            char c = this.termAtt.charAt(i);
            if (this.alphabetic && 'a' <= c && 'z' >= c) {
                return true;
            }
            if (this.digit && Character.isDigit(c)) {
                return true;
            }
            if (!this.letter || !Character.isLetter(c)) continue;
            return true;
        }
        return false;
    }
}

