/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.ja;

import java.io.Reader;
import org.codelibs.analysis.BufferedCharFilter;

public class IterationMarkCharFilter
extends BufferedCharFilter {
    private static final String UNVOICED_CONSONANT_HIRAGANA = "\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306f\u3072\u3075\u3078\u307b\u306f\u3072\u3075\u3078\u307b";
    private static final String VOICED_SOUND_MARK_HIRAGANA = "\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u307a\u307d";
    private static final String UNVOICED_CONSONANT_KATAKANA = "\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db\u30cf\u30d2\u30d5\u30d8\u30db";
    private static final String VOICED_SOUND_MARK_KATAKANA = "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd";
    private static final char U3005 = '\u3005';
    private static final char U309D = '\u309d';
    private static final char U309E = '\u309e';
    private static final char U30FD = '\u30fd';
    private static final char U30FE = '\u30fe';
    private static final char U303B = '\u303b';

    public IterationMarkCharFilter(Reader in) {
        super(in);
    }

    @Override
    protected CharSequence processInput(CharSequence input) {
        StringBuilder buf = new StringBuilder(input.length());
        int pos = 0;
        block8: while (pos < input.length()) {
            char c = input.charAt(pos);
            switch (c) {
                case '\u3005': {
                    char next;
                    if (pos + 1 < input.length() && (next = input.charAt(pos + 1)) == '\u3005') {
                        if (pos - 2 >= 0) {
                            char prev2 = input.charAt(pos - 2);
                            char prev1 = input.charAt(pos - 1);
                            if (Character.UnicodeBlock.of(prev2) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
                                buf.append(prev2);
                                buf.append(prev1);
                            } else {
                                buf.append(prev1);
                                buf.append(prev1);
                            }
                            pos += 2;
                            continue block8;
                        }
                        if (pos - 1 >= 0) {
                            buf.append(input.charAt(pos - 1));
                            buf.append(input.charAt(pos - 1));
                            pos += 2;
                            continue block8;
                        }
                        buf.append(c);
                        ++pos;
                        continue block8;
                    }
                    if (pos - 1 >= 0) {
                        buf.append(input.charAt(pos - 1));
                    } else {
                        buf.append(c);
                    }
                    ++pos;
                    continue block8;
                }
                case '\u309d': {
                    int index;
                    char prev;
                    if (pos - 1 >= 0) {
                        prev = input.charAt(pos - 1);
                        index = VOICED_SOUND_MARK_HIRAGANA.indexOf(prev);
                        if (index >= 0) {
                            buf.append(UNVOICED_CONSONANT_HIRAGANA.charAt(index));
                        } else {
                            buf.append(prev);
                        }
                    } else {
                        buf.append(c);
                    }
                    ++pos;
                    continue block8;
                }
                case '\u309e': {
                    int index;
                    char prev;
                    if (pos - 1 >= 0) {
                        prev = input.charAt(pos - 1);
                        index = UNVOICED_CONSONANT_HIRAGANA.indexOf(prev);
                        if (index >= 0) {
                            buf.append(VOICED_SOUND_MARK_HIRAGANA.charAt(index));
                        } else {
                            buf.append(prev);
                        }
                    } else {
                        buf.append(c);
                    }
                    ++pos;
                    continue block8;
                }
                case '\u30fd': {
                    int index;
                    char prev;
                    if (pos - 1 >= 0) {
                        prev = input.charAt(pos - 1);
                        index = VOICED_SOUND_MARK_KATAKANA.indexOf(prev);
                        if (index >= 0) {
                            buf.append(UNVOICED_CONSONANT_KATAKANA.charAt(index));
                        } else {
                            buf.append(prev);
                        }
                    } else {
                        buf.append(c);
                    }
                    ++pos;
                    continue block8;
                }
                case '\u30fe': {
                    int index;
                    char prev;
                    if (pos - 1 >= 0) {
                        prev = input.charAt(pos - 1);
                        index = UNVOICED_CONSONANT_KATAKANA.indexOf(prev);
                        if (index >= 0) {
                            buf.append(VOICED_SOUND_MARK_KATAKANA.charAt(index));
                        } else {
                            buf.append(prev);
                        }
                    } else {
                        buf.append(c);
                    }
                    ++pos;
                    continue block8;
                }
                case '\u303b': {
                    if (pos - 1 >= 0) {
                        buf.append(input.charAt(pos - 1));
                    } else {
                        buf.append(c);
                    }
                    ++pos;
                    continue block8;
                }
            }
            buf.append(c);
            ++pos;
        }
        return buf;
    }
}

