/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.ja;

import java.io.Reader;
import org.codelibs.analysis.BufferedCharFilter;

public class ProlongedSoundMarkCharFilter
extends BufferedCharFilter {
    private static final char U002D = '-';
    private static final char UFF0D = '\uff0d';
    private static final char U2010 = '\u2010';
    private static final char U2011 = '\u2011';
    private static final char U2012 = '\u2012';
    private static final char U2013 = '\u2013';
    private static final char U2014 = '\u2014';
    private static final char U2015 = '\u2015';
    private static final char U207B = '\u207b';
    private static final char U208B = '\u208b';
    private static final char U30FC = '\u30fc';
    private final char replacement;

    public ProlongedSoundMarkCharFilter(Reader in) {
        this(in, '\u30fc');
    }

    public ProlongedSoundMarkCharFilter(Reader in, char replacement) {
        super(in);
        this.replacement = replacement;
    }

    @Override
    protected CharSequence processInput(CharSequence input) {
        StringBuilder buf = new StringBuilder(input.length());
        char prev = '\u0000';
        for (int pos = 0; pos < input.length(); ++pos) {
            char c = input.charAt(pos);
            switch (c) {
                case '-': 
                case '\u2010': 
                case '\u2011': 
                case '\u2012': 
                case '\u2013': 
                case '\u2014': 
                case '\u2015': 
                case '\u207b': 
                case '\u208b': 
                case '\u30fc': 
                case '\uff0d': {
                    if (prev != '\u0000') {
                        Character.UnicodeBlock block = Character.UnicodeBlock.of(prev);
                        if (block == Character.UnicodeBlock.HIRAGANA || block == Character.UnicodeBlock.KATAKANA || block == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS) {
                            buf.append(this.replacement);
                            break;
                        }
                        buf.append(c);
                        break;
                    }
                    buf.append(c);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            prev = c;
        }
        return buf;
    }
}

