/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.curl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.io.ContentCache;

public class CurlResponse
implements Closeable {
    private int httpStatusCode;
    private ContentCache contentCache;
    private String encoding;
    private Exception contentException;
    private Map<String, List<String>> headers;

    @Override
    public void close() throws IOException {
        if (this.contentCache != null) {
            this.contentCache.close();
        }
    }

    public <T> T getContent(Function<CurlResponse, T> parser) {
        return parser.apply(this);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getContentAsString() {
        byte[] bytes = new byte[4096];
        try (BufferedInputStream bis = new BufferedInputStream(this.getContentAsStream());){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int length = bis.read(bytes);
                while (length != -1) {
                    if (length != 0) {
                        baos.write(bytes, 0, length);
                    }
                    length = bis.read(bytes);
                }
                string = baos.toString(this.encoding);
            }
            return string;
        }
        catch (Exception e) {
            throw new CurlException("Failed to access the content.", e);
        }
    }

    public InputStream getContentAsStream() throws IOException {
        if (this.contentCache == null) {
            if (this.contentException != null) {
                throw new CurlException("The content does not exist.", this.contentException);
            }
            throw new CurlException("The content does not exist.");
        }
        return this.contentCache.getInputStream();
    }

    public void setContentCache(ContentCache contentCache) {
        this.contentCache = contentCache;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setContentException(Exception e) {
        this.contentException = e;
    }

    public Exception getContentException() {
        return this.contentException;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            headers.entrySet().stream().filter(e -> e.getKey() != null).forEach(e -> map.put(((String)e.getKey()).toLowerCase(Locale.ROOT), (List)e.getValue()));
            this.headers = map;
        }
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String[] getHeaderValues(String name) {
        List<String> list = this.headers.get(name.toLowerCase(Locale.ROOT));
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public String getHeaderValue(String name) {
        String[] values = this.getHeaderValues(name);
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }
}

