/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.curl.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.logging.Logger;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class ContentOutputStream
extends DeferredFileOutputStream {
    protected static final Logger logger = Logger.getLogger(ContentOutputStream.class.getName());
    protected static final String PREFIX = "curl4j-";
    protected static final String SUFFIX = ".tmp";
    protected boolean done = false;

    public ContentOutputStream(int threshold, File tmpDir) {
        super(threshold, PREFIX, SUFFIX, tmpDir);
    }

    public File getFile() {
        this.done = true;
        return super.getFile();
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            File file;
            if (!this.isInMemory() && !this.done && (file = super.getFile()) != null) {
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException e) {
                    logger.warning(e.getLocalizedMessage());
                }
            }
        }
    }
}

