/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.curl.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.logging.Logger;

public class ContentCache
implements Closeable {
    protected static final Logger logger = Logger.getLogger(ContentCache.class.getName());
    private final byte[] data;
    private final File file;

    public ContentCache(byte[] data) {
        this.data = data;
        this.file = null;
    }

    public ContentCache(File file) {
        this.data = null;
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            Files.delete(this.file.toPath());
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return new ByteArrayInputStream(this.data);
    }
}

