/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.kuromoji.neologd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiAnalyzerProvider;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiBaseFormFilterFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiIterationMarkCharFilterFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiKatakanaStemmerFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiNumberFilterFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiPartOfSpeechFilterFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiReadingFormFilterFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.KuromojiTokenizerFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.PosConcatenationFilterFactory;
import org.codelibs.elasticsearch.kuromoji.neologd.index.analysis.ReloadableKuromojiTokenizerFactory;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;

public class KuromojiNeologdPlugin
extends Plugin
implements AnalysisPlugin {
    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.singletonMap("kuromoji_neologd_iteration_mark", KuromojiIterationMarkCharFilterFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        extra.put("kuromoji_neologd_baseform", KuromojiBaseFormFilterFactory::new);
        extra.put("kuromoji_neologd_part_of_speech", KuromojiPartOfSpeechFilterFactory::new);
        extra.put("kuromoji_neologd_readingform", KuromojiReadingFormFilterFactory::new);
        extra.put("kuromoji_neologd_stemmer", KuromojiKatakanaStemmerFactory::new);
        extra.put("kuromoji_neologd_number", KuromojiNumberFilterFactory::new);
        extra.put("kuromoji_neologd_pos_concat", PosConcatenationFilterFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>>();
        extra.put("kuromoji_neologd_tokenizer", KuromojiTokenizerFactory::new);
        extra.put("reloadable_kuromoji_neologd_tokenizer", ReloadableKuromojiTokenizerFactory::new);
        extra.put("reloadable_kuromoji_neologd", ReloadableKuromojiTokenizerFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.singletonMap("kuromoji_neologd", KuromojiAnalyzerProvider::new);
    }
}

