/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.kuromoji.neologd.index.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.neologd.ipadic.lucene.analysis.ja.JapaneseAnalyzer;
import org.codelibs.neologd.ipadic.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class KuromojiPartOfSpeechFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<String> stopTags = new HashSet<String>();

    public KuromojiPartOfSpeechFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        List wordList = Analysis.getWordList((Environment)env, (Settings)settings, (String)"stoptags");
        if (wordList != null) {
            this.stopTags.addAll(wordList);
        } else {
            this.stopTags.addAll(JapaneseAnalyzer.getDefaultStopTags());
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapanesePartOfSpeechStopFilter(tokenStream, this.stopTags);
    }
}

