/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.codelibs.elasticsearch.runner.net.Curl;
import org.codelibs.elasticsearch.runner.net.CurlException;
import org.codelibs.elasticsearch.runner.net.CurlResponse;
import org.elasticsearch.node.Node;

public class CurlRequest {
    protected String url;
    protected String encoding = "UTF-8";
    protected Curl.Method method;
    protected List<String> paramList;
    protected String body;

    public CurlRequest(Curl.Method method, String url) {
        this.method = method;
        this.url = url;
    }

    public CurlRequest(Curl.Method method, Node node, String path) {
        this.method = method;
        StringBuilder urlBuf = new StringBuilder(200);
        urlBuf.append("http://localhost:").append(node.settings().get("http.port"));
        if (path.startsWith("/")) {
            urlBuf.append(path);
        } else {
            urlBuf.append('/').append(path);
        }
        this.url = urlBuf.toString();
    }

    public CurlRequest encoding(String encoding) {
        if (this.paramList != null) {
            throw new CurlException("This method must be called before param method.");
        }
        this.encoding = encoding;
        return this;
    }

    public CurlRequest body(String body) {
        this.body = body;
        return this;
    }

    public CurlRequest param(String key, String value) {
        if (this.paramList == null) {
            this.paramList = new ArrayList<String>();
        }
        this.paramList.add(this.encode(key) + "=" + this.encode(value));
        return this;
    }

    public void execute(Curl.ResponseListener listener) {
        if (this.paramList != null) {
            int sp = this.url.indexOf(63) == -1 ? 63 : 38;
            StringBuilder urlBuf = new StringBuilder(this.url.length() + 100);
            for (String param : this.paramList) {
                urlBuf.append((char)sp).append(param);
                if (sp != 63) continue;
                sp = 38;
            }
            if (Curl.Method.GET == this.method || this.body != null) {
                this.url = this.url + urlBuf.toString();
            } else {
                this.body = urlBuf.substring(1);
            }
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setRequestMethod(this.method.toString());
            if (this.body != null) {
                connection.setDoOutput(true);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), this.encoding));
                Object object = null;
                try {
                    writer.write(this.body);
                    writer.flush();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            listener.onResponse(connection);
        }
        catch (Exception e) {
            throw new CurlException("Failed to access to " + this.url, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public CurlResponse execute() {
        final CurlResponse response = new CurlResponse();
        this.execute(new Curl.ResponseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(HttpURLConnection con) {
                try {
                    response.setHttpStatusCode(con.getResponseCode());
                    response.setEncoding(CurlRequest.this.encoding);
                    Path tempFile = Files.createTempFile("esrunner-", ".tmp", new FileAttribute[0]);
                    try (BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
                         BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(tempFile, StandardOpenOption.WRITE));){
                        byte[] bytes = new byte[4096];
                        try {
                            int length = bis.read(bytes);
                            while (length != -1) {
                                if (length != 0) {
                                    bos.write(bytes, 0, length);
                                }
                                length = bis.read(bytes);
                            }
                        }
                        finally {
                            bytes = null;
                        }
                        bos.flush();
                        response.setContentFile(tempFile);
                    }
                    catch (Exception e) {
                        response.setContentException(e);
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (Exception ignore) {}
                    }
                }
                catch (Exception e) {
                    throw new CurlException("Failed to access the response.", e);
                }
            }
        });
        return response;
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(value, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new CurlException("Invalid encoding: " + this.encoding, e);
        }
    }
}

