/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.codelibs.elasticsearch.runner.net.CurlException;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class CurlResponse
implements Closeable {
    private int httpStatusCode;
    private Path tempFile;
    private String encoding;
    private Exception contentException;

    @Override
    public void close() throws IOException {
        if (this.tempFile != null) {
            Files.delete(this.tempFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getContentAsMap() {
        try (InputStream is = this.getContentAsStream();){
            Map map = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, is).map();
            return map;
        }
        catch (Exception e) {
            throw new CurlException("Failed to access the content.", e);
        }
    }

    /*
     * Exception decompiling
     */
    public String getContentAsString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getContentAsStream() throws IOException {
        if (this.tempFile == null) {
            if (this.contentException != null) {
                throw new CurlException("The content does not exist.", this.contentException);
            }
            throw new CurlException("The content does not exist.");
        }
        return Files.newInputStream(this.tempFile, StandardOpenOption.READ);
    }

    public void setContentFile(Path tempFile) {
        this.tempFile = tempFile;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setContentException(Exception e) {
        this.contentException = e;
    }

    public Exception getContentException() {
        return this.contentException;
    }
}

