/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.runner.net;

import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.Curl;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.node.Node;

public class EcrCurl {
    public static Function<CurlResponse, Map<String, Object>> jsonParser = response -> {
        Map map;
        block8: {
            InputStream is = response.getContentAsStream();
            try {
                map = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, is).map();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CurlException("Failed to access the content.", (Throwable)e);
                }
            }
            is.close();
        }
        return map;
    };

    protected EcrCurl() {
    }

    public static CurlRequest get(Node node, String path) {
        return new CurlRequest(Curl.Method.GET, EcrCurl.getUrl(node, path));
    }

    public static CurlRequest post(Node node, String path) {
        return new CurlRequest(Curl.Method.POST, EcrCurl.getUrl(node, path));
    }

    public static CurlRequest put(Node node, String path) {
        return new CurlRequest(Curl.Method.PUT, EcrCurl.getUrl(node, path));
    }

    public static CurlRequest delete(Node node, String path) {
        return new CurlRequest(Curl.Method.DELETE, EcrCurl.getUrl(node, path));
    }

    protected static String getUrl(Node node, String path) {
        StringBuilder urlBuf = new StringBuilder(200);
        urlBuf.append("http://localhost:").append(node.settings().get("http.port"));
        if (path.startsWith("/")) {
            urlBuf.append(path);
        } else {
            urlBuf.append('/').append(path);
        }
        return urlBuf.toString();
    }

    public static CurlRequest get(String url) {
        return new CurlRequest(Curl.Method.GET, url);
    }

    public static CurlRequest post(String url) {
        return new CurlRequest(Curl.Method.POST, url);
    }

    public static CurlRequest put(String url) {
        return new CurlRequest(Curl.Method.PUT, url);
    }

    public static CurlRequest delete(String url) {
        return new CurlRequest(Curl.Method.DELETE, url);
    }
}

