/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.codelibs.elasticsearch.configsync.action.FileFlushAction;
import org.codelibs.elasticsearch.configsync.action.ResetSyncAction;
import org.codelibs.elasticsearch.configsync.action.TransportFileFlushAction;
import org.codelibs.elasticsearch.configsync.action.TransportResetSyncAction;
import org.codelibs.elasticsearch.configsync.rest.RestConfigSyncFileAction;
import org.codelibs.elasticsearch.configsync.rest.RestConfigSyncFlushAction;
import org.codelibs.elasticsearch.configsync.rest.RestConfigSyncResetAction;
import org.codelibs.elasticsearch.configsync.rest.RestConfigSyncWaitAction;
import org.codelibs.elasticsearch.configsync.service.ConfigSyncService;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class ConfigSyncPlugin
extends Plugin
implements ActionPlugin {
    ConfigSyncService service;

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)FileFlushAction.INSTANCE, TransportFileFlushAction.class), new ActionPlugin.ActionHandler((ActionType)ResetSyncAction.INSTANCE, TransportResetSyncAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestConfigSyncFileAction(settings, restController, this.service), new RestConfigSyncResetAction(settings, restController, this.service), new RestConfigSyncFlushAction(settings, restController, this.service), new RestConfigSyncWaitAction(settings, restController, this.service)});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider telemetryProvider, AllocationService allocationService, IndicesService indicesService) {
        ArrayList<Object> components = new ArrayList<Object>();
        this.service = new ConfigSyncService(client, clusterService, environment, threadPool);
        components.add((Object)this.service);
        return components;
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(ConfigSyncService.INDEX_SETTING, ConfigSyncService.XPACK_SECURITY_USER_SETTING, ConfigSyncService.XPACK_SECURITY_PASSWORD_SETTING, ConfigSyncService.CONFIG_PATH_SETTING, ConfigSyncService.SCROLL_TIME_SETTING, ConfigSyncService.SCROLL_SIZE_SETTING, ConfigSyncService.FLUSH_INTERVAL_SETTING, ConfigSyncService.FILE_UPDATER_ENABLED_SETTING);
    }
}

