/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.codelibs.elasticsearch.configsync.action.ConfigFileFlushResponse;
import org.codelibs.elasticsearch.configsync.action.FileFlushRequest;
import org.codelibs.elasticsearch.configsync.action.FileFlushResponse;
import org.codelibs.elasticsearch.configsync.service.ConfigSyncService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportFileFlushAction
extends HandledTransportAction<FileFlushRequest, FileFlushResponse> {
    private final TransportService transportService;
    private final ConfigSyncService configSyncService;

    @Inject
    public TransportFileFlushAction(TransportService transportService, ActionFilters actionFilters, ConfigSyncService configSyncService) {
        super("cluster:admin/configsync/flush", transportService, actionFilters, FileFlushRequest::new);
        this.transportService = transportService;
        this.configSyncService = configSyncService;
        configSyncService.setFileFlushAction(this);
    }

    protected void doExecute(Task task, FileFlushRequest request, ActionListener<FileFlushResponse> listener) {
        this.configSyncService.newConfigFileWriter().execute((ActionListener<Void>)ActionListener.wrap(response -> listener.onResponse((Object)new FileFlushResponse(true)), e -> listener.onFailure(e)));
    }

    public void sendRequest(final Iterator<DiscoveryNode> nodesIt, final ActionListener<ConfigFileFlushResponse> listener) {
        DiscoveryNode node = nodesIt.next();
        this.transportService.sendRequest(node, "cluster:admin/configsync/flush", (TransportRequest)new FileFlushRequest(), (TransportResponseHandler)new TransportResponseHandler<FileFlushResponse>(){

            public FileFlushResponse read(StreamInput in) throws IOException {
                return new FileFlushResponse(in);
            }

            public void handleResponse(FileFlushResponse response) {
                TransportFileFlushAction.this.configSyncService.flushOnNode(nodesIt, (ActionListener<ConfigFileFlushResponse>)listener);
            }

            public void handleException(TransportException exp) {
                listener.onFailure((Exception)exp);
            }

            public Executor executor(ThreadPool threadPool) {
                return threadPool.generic();
            }
        });
    }
}

