/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codelibs.elasticsearch.configsync.rest.RestConfigSyncAction;
import org.codelibs.elasticsearch.configsync.service.ConfigSyncService;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public class RestConfigSyncWaitAction
extends RestConfigSyncAction {
    private final ConfigSyncService configSyncService;

    @Inject
    public RestConfigSyncWaitAction(Settings settings, RestController controller, ConfigSyncService configSyncService) {
        this.configSyncService = configSyncService;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_configsync/wait")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try {
            switch (request.method()) {
                case GET: {
                    String status = request.param("status", "yellow");
                    String timeout = request.param("timeout", "30s");
                    return channel -> this.configSyncService.waitForStatus(status, timeout, (ActionListener<ClusterHealthResponse>)ActionListener.wrap(response -> this.sendResponse((RestChannel)channel, null), e -> this.sendErrorResponse((RestChannel)channel, (Exception)e)));
                }
            }
            return channel -> this.sendErrorResponse((RestChannel)channel, (Exception)new ElasticsearchException("Unknown request type.", new Object[0]));
        }
        catch (Exception e) {
            return channel -> this.sendErrorResponse((RestChannel)channel, e);
        }
    }

    public String getName() {
        return "configsync_wait_action";
    }
}

