/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.configsync.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.elasticsearch.configsync.action.ConfigFileFlushResponse;
import org.codelibs.elasticsearch.configsync.action.ConfigResetSyncResponse;
import org.codelibs.elasticsearch.configsync.action.TransportFileFlushAction;
import org.codelibs.elasticsearch.configsync.action.TransportResetSyncAction;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.json.JsonXContent;

public class ConfigSyncService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(ConfigSyncService.class);
    public static final Setting<Boolean> FILE_UPDATER_ENABLED_SETTING = Setting.boolSetting((String)"configsync.file_updater.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> FLUSH_INTERVAL_SETTING = Setting.timeSetting((String)"configsync.flush_interval", (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SCROLL_SIZE_SETTING = Setting.intSetting((String)"configsync.scroll_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SCROLL_TIME_SETTING = Setting.timeSetting((String)"configsync.scroll_time", (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> CONFIG_PATH_SETTING = Setting.simpleString((String)"configsync.config_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> INDEX_SETTING = new Setting("configsync.index", s -> "configsync", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> XPACK_SECURITY_USER_SETTING = new Setting("configsync.xpack.security.user", s -> "elastic", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<SecureString> XPACK_SECURITY_PASSWORD_SETTING = SecureSetting.secureString((String)"configsync.xpack.security.password", null, (Setting.Property[])new Setting.Property[0]);
    private static final String FILE_MAPPING_JSON = "configsync/file_mapping.json";
    public static final String TIMESTAMP = "@timestamp";
    public static final String CONTENT = "content";
    public static final String PATH = "path";
    private final Client client;
    private final String index;
    private String configPath;
    private final ThreadPool threadPool;
    private final TimeValue scrollForUpdate;
    private final int sizeForUpdate;
    private Date lastChecked = new Date(0L);
    private ConfigFileUpdater configFileUpdater;
    private final ClusterService clusterService;
    private Scheduler.ScheduledCancellable scheduledCancellable;
    private final boolean fileUpdaterEnabled;
    private final String authorizationToken;
    private final TimeValue flushInterval;
    private TransportFileFlushAction fileFlushAction;
    private TransportResetSyncAction resetSyncAction;

    private static String xpackSecurityToken(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        String basicAuth = Base64.getEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_8));
        return "Basic " + basicAuth;
    }

    public ConfigSyncService(Client client, ClusterService clusterService, Environment environment, ThreadPool threadPool) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if (logger.isDebugEnabled()) {
            logger.debug("Creating ConfigSyncService");
        }
        Settings settings = environment.settings();
        this.index = (String)INDEX_SETTING.get(settings);
        this.configPath = (String)CONFIG_PATH_SETTING.get(settings);
        if (this.configPath.length() == 0) {
            this.configPath = environment.configFile().toFile().getAbsolutePath();
        }
        this.scrollForUpdate = (TimeValue)SCROLL_TIME_SETTING.get(settings);
        this.sizeForUpdate = (Integer)SCROLL_SIZE_SETTING.get(settings);
        this.fileUpdaterEnabled = (Boolean)FILE_UPDATER_ENABLED_SETTING.get(settings);
        this.flushInterval = (TimeValue)FLUSH_INTERVAL_SETTING.get(settings);
        try (SecureString password = (SecureString)XPACK_SECURITY_PASSWORD_SETTING.get(settings);){
            if (password.length() > 0) {
                String user = (String)XPACK_SECURITY_USER_SETTING.get(settings);
                this.authorizationToken = ConfigSyncService.xpackSecurityToken(user + ":" + password.toString());
                logger.info("Created authorization token for {}", (Object)user);
            } else {
                this.authorizationToken = "";
            }
        }
    }

    private Client client() {
        if (this.authorizationToken.length() > 0) {
            return this.client.filterWithHeader(Collections.singletonMap("Authorization", this.authorizationToken));
        }
        return this.client;
    }

    private TimeValue startUpdater() {
        TimeValue interval;
        this.configFileUpdater = new ConfigFileUpdater();
        if (this.scheduledCancellable != null) {
            this.scheduledCancellable.cancel();
        }
        if ((interval = this.clusterService.state().getMetadata().settings().getAsTime(FLUSH_INTERVAL_SETTING.getKey(), this.flushInterval)).millis() < 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("ConfigFileUpdater is not scheduled.");
            }
        } else {
            this.scheduledCancellable = this.threadPool.schedule((Runnable)this.configFileUpdater, interval, (Executor)this.threadPool.executor("same"));
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduled ConfigFileUpdater with {}", (Object)interval);
            }
        }
        return interval;
    }

    protected void doStart() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting ConfigSyncService");
        }
        this.clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                ConfigSyncService.this.waitForClusterReady();
            }
        });
    }

    private void waitForClusterReady() {
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().execute(ActionListener.wrap(res -> {
            if (res.isTimedOut()) {
                logger.warn("Cluster service was timeouted.");
            }
            this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(response -> {
                TimeValue time;
                if (this.fileUpdaterEnabled && (time = this.startUpdater()).millis() >= 0L) {
                    logger.info("ConfigFileUpdater is started at {} intervals.", (Object)time);
                }
            }, e -> {
                if (e instanceof ElasticsearchSecurityException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Could not create configsync. Retrying to start it.", (Throwable)e);
                    }
                } else {
                    logger.warn("Could not create configsync. Retrying to start it.", (Throwable)e);
                }
                this.threadPool.schedule(this::waitForClusterReady, TimeValue.timeValueSeconds((long)15L), (Executor)this.threadPool.generic());
            }));
        }, e -> {
            logger.warn("Could not start ConfigFileUpdater. Retrying to start it.", (Throwable)e);
            this.threadPool.schedule(this::waitForClusterReady, TimeValue.timeValueSeconds((long)15L), (Executor)this.threadPool.generic());
        }));
    }

    private void checkIfIndexExists(ActionListener<ActionResponse> listener) {
        ((GetIndexRequestBuilder)this.client().admin().indices().prepareGetIndex().addIndices(new String[]{this.index})).execute(ActionListener.wrap(response -> {
            if (response.indices().length > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} exists.", (Object)this.index);
                }
                listener.onResponse(response);
            } else {
                this.createIndex(listener);
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                this.createIndex(listener);
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void createIndex(ActionListener<ActionResponse> listener) {
        try (InputStreamReader in = new InputStreamReader(ConfigSyncService.class.getClassLoader().getResourceAsStream(FILE_MAPPING_JSON), StandardCharsets.UTF_8);){
            String source = Streams.copyToString((Reader)in);
            XContentBuilder settingsBuilder = XContentFactory.jsonBuilder().startObject().startObject("index").field("number_of_shards", 1).field("number_of_replicas", 0).field("auto_expand_replicas", "0-all").endObject().endObject();
            this.client().admin().indices().prepareCreate(this.index).setSettings(settingsBuilder).setMapping(source).execute(ActionListener.wrap(response -> this.waitForIndex(listener), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    private void waitForIndex(ActionListener<ActionResponse> listener) {
        this.client.admin().cluster().prepareHealth(new String[]{this.index}).setWaitForYellowStatus().execute(ActionListener.wrap(response -> listener.onResponse(response), arg_0 -> listener.onFailure(arg_0)));
    }

    protected void doStop() {
        if (this.configFileUpdater != null) {
            this.configFileUpdater.terminate();
        }
    }

    protected void doClose() {
    }

    public void store(String path, byte[] contentArray, ActionListener<DocWriteResponse> listener) {
        this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(response -> {
            try {
                String id = this.getId(path);
                XContentBuilder builder = JsonXContent.contentBuilder();
                builder.startObject();
                builder.field(PATH, path);
                builder.field(CONTENT, contentArray);
                builder.field(TIMESTAMP, (Object)new Date());
                builder.endObject();
                ((IndexRequestBuilder)this.client().prepareIndex(this.index).setId(id).setSource(builder).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute(listener);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to register " + path, (Throwable)e, new Object[0]);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getPaths(int from, int size, String[] fields, String sortField, String sortOrder, ActionListener<List<Object>> listener) {
        this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(res -> {
            String[] stringArray;
            boolean hasFields = fields != null && fields.length != 0;
            SearchRequestBuilder searchRequestBuilder = this.client().prepareSearch(new String[]{this.index}).setSize(size).setFrom(from);
            if (hasFields) {
                stringArray = fields;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = PATH;
            }
            searchRequestBuilder.setFetchSource(stringArray, null).addSort(sortField, SortOrder.DESC.toString().equalsIgnoreCase(sortOrder) ? SortOrder.DESC : SortOrder.ASC).execute(ActionListener.wrap(response -> {
                ArrayList objList = new ArrayList();
                for (SearchHit hit : response.getHits().getHits()) {
                    if (hasFields) {
                        HashMap objMap = new HashMap();
                        for (String field : fields) {
                            objMap.put(field, hit.getSourceAsMap().get(field));
                        }
                        objList.add(objMap);
                        continue;
                    }
                    objList.add(hit.getSourceAsMap().get(PATH));
                }
                listener.onResponse(objList);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private String getId(String path) {
        return org.apache.commons.codec.binary.Base64.encodeBase64URLSafeString((byte[])path.getBytes(StandardCharsets.UTF_8));
    }

    public void resetSync(ActionListener<ConfigResetSyncResponse> listener) {
        this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(response -> {
            ClusterState state = this.clusterService.state();
            DiscoveryNodes nodes = state.nodes();
            Iterator<DiscoveryNode> nodesIt = nodes.getDataNodes().values().iterator();
            this.resetSync(nodesIt, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void resetSync(Iterator<DiscoveryNode> nodesIt, ActionListener<ConfigResetSyncResponse> listener) {
        if (!nodesIt.hasNext()) {
            listener.onResponse((Object)new ConfigResetSyncResponse(true));
        } else {
            this.resetSyncAction.sendRequest(nodesIt, listener);
        }
    }

    public void restartUpdater(ActionListener<ActionResponse> listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Restarting ConfigFileUpdater...");
        }
        try {
            if (this.configFileUpdater != null) {
                this.configFileUpdater.terminate();
            }
            this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(response -> {
                TimeValue time = this.startUpdater();
                if (time.millis() >= 0L) {
                    logger.info("ConfigFileUpdater is started at {} intervals.", (Object)time);
                }
                listener.onResponse(response);
            }, e -> {
                logger.error("Failed to restart ConfigFileUpdater.", (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void flush(ActionListener<ConfigFileFlushResponse> listener) {
        this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(response -> {
            ClusterState state = this.clusterService.state();
            DiscoveryNodes nodes = state.nodes();
            Iterator<DiscoveryNode> nodesIt = nodes.getDataNodes().values().iterator();
            this.flushOnNode(nodesIt, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void flushOnNode(Iterator<DiscoveryNode> nodesIt, ActionListener<ConfigFileFlushResponse> listener) {
        if (!nodesIt.hasNext()) {
            listener.onResponse((Object)new ConfigFileFlushResponse(true));
        } else {
            this.fileFlushAction.sendRequest(nodesIt, listener);
        }
    }

    public void getContent(String path, ActionListener<byte[]> listener) {
        this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(res -> this.client().prepareGet(this.index, this.getId(path)).execute(ActionListener.wrap(response -> {
            if (response.isExists()) {
                byte[] configContent = org.apache.commons.codec.binary.Base64.decodeBase64((String)((String)response.getSource().get(CONTENT)));
                listener.onResponse((Object)configContent);
            } else {
                listener.onResponse(null);
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    public void delete(String path, ActionListener<DeleteResponse> listener) {
        this.checkIfIndexExists((ActionListener<ActionResponse>)ActionListener.wrap(response -> ((DeleteRequestBuilder)this.client().prepareDelete(this.index, this.getId(path)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute(listener), arg_0 -> listener.onFailure(arg_0)));
    }

    public void waitForStatus(String waitForStatus, String timeout, ActionListener<ClusterHealthResponse> listener) {
        try {
            this.client.admin().cluster().prepareHealth(new String[]{this.index}).setWaitForStatus(ClusterHealthStatus.fromString((String)waitForStatus)).setTimeout(timeout).execute(listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void updateConfigFile(Map<String, Object> source) {
        try {
            Exception e;
            Date timestamp = this.getTimestamp(source.get(TIMESTAMP));
            String path = (String)source.get(PATH);
            Path filePath = Paths.get(this.configPath, path.replace("..", ""));
            if (logger.isDebugEnabled()) {
                logger.debug("Checking {}", (Object)filePath);
            }
            if ((e = AccessController.doPrivileged(() -> {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("timestamp(index): {}", (Object)timestamp.getTime());
                        if (Files.exists(filePath, new LinkOption[0])) {
                            logger.debug("timestamp(file):  {}", (Object)Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis());
                        }
                    }
                    if (!Files.exists(filePath, new LinkOption[0]) || Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis() < timestamp.getTime()) {
                        String content = (String)source.get(CONTENT);
                        File parentFile = filePath.toFile().getParentFile();
                        if (!parentFile.exists() && !parentFile.mkdirs()) {
                            logger.warn("Failed to create " + parentFile.getAbsolutePath());
                        }
                        String absolutePath = filePath.toFile().getAbsolutePath();
                        ConfigSyncService.decodeToFile(content, absolutePath);
                        logger.info("Updated " + absolutePath);
                    }
                }
                catch (Exception e1) {
                    return e1;
                }
                return null;
            })) != null) {
                throw e;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to update " + source.get(PATH), (Throwable)e);
        }
    }

    private Date getTimestamp(Object value) throws ParseException {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.parse(value.toString());
    }

    public ConfigFileWriter newConfigFileWriter() {
        return new ConfigFileWriter();
    }

    private static void decodeToFile(String dataToDecode, String filename) throws IOException {
        try (Base64OutputStream os = new Base64OutputStream((OutputStream)new FileOutputStream(filename), false);){
            os.write(dataToDecode.getBytes(StandardCharsets.UTF_8));
        }
    }

    public void setFileFlushAction(TransportFileFlushAction fileFlushAction) {
        this.fileFlushAction = fileFlushAction;
    }

    public void setResetSyncAction(TransportResetSyncAction resetSyncAction) {
        this.resetSyncAction = resetSyncAction;
    }

    class ConfigFileUpdater
    implements Runnable {
        ConfigFileWriter writer;

        ConfigFileUpdater() {
            this.writer = new ConfigFileWriter();
        }

        @Override
        public void run() {
            if (this.writer.terminated.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Terminated {}", (Object)this);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Processing ConfigFileUpdater.");
            }
            this.writer.execute((ActionListener<Void>)ActionListener.wrap(response -> ConfigSyncService.this.startUpdater(), e -> {
                logger.error("Failed to process ConfigFileUpdater.", (Throwable)e);
                ConfigSyncService.this.startUpdater();
            }));
        }

        public void terminate() {
            this.writer.terminate();
        }
    }

    public class ConfigFileWriter
    implements ActionListener<SearchResponse> {
        private final AtomicBoolean terminated = new AtomicBoolean(false);
        private ActionListener<Void> listener;

        public void execute(ActionListener<Void> listener) {
            this.listener = listener;
            Date now = new Date();
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)ConfigSyncService.TIMESTAMP).from((Object)ConfigSyncService.this.lastChecked.getTime()));
            ConfigSyncService.this.lastChecked = now;
            ConfigSyncService.this.client().prepareSearch(new String[]{ConfigSyncService.this.index}).setQuery((QueryBuilder)queryBuilder).setScroll(ConfigSyncService.this.scrollForUpdate).setSize(ConfigSyncService.this.sizeForUpdate).execute((ActionListener)this);
        }

        public void terminate() {
            this.terminated.set(true);
        }

        public void onResponse(SearchResponse response) {
            if (this.terminated.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Terminated {}", (Object)this);
                }
                this.listener.onFailure((Exception)new ElasticsearchException("Config Writing process was terminated.", new Object[0]));
                return;
            }
            SearchHits searchHits = response.getHits();
            SearchHit[] hits = searchHits.getHits();
            if (hits.length == 0) {
                this.listener.onResponse(null);
            } else {
                for (SearchHit hit : hits) {
                    Map source = hit.getSourceAsMap();
                    ConfigSyncService.this.updateConfigFile(source);
                }
                String scrollId = response.getScrollId();
                ConfigSyncService.this.client().prepareSearchScroll(scrollId).setScroll(ConfigSyncService.this.scrollForUpdate).execute((ActionListener)this);
            }
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

