/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.df.util;

import java.util.Collection;

public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final String UTF_8 = "UTF-8";

    private StringUtils() {
    }

    public static boolean isEmpty(Collection<String> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String text : c) {
            if (!StringUtils.isNotEmpty(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(Collection<String> c) {
        return !StringUtils.isEmpty(c);
    }

    public static boolean isBlank(Collection<String> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String text : c) {
            if (!StringUtils.isNotBlank(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(Collection<String> c) {
        return !StringUtils.isBlank(c);
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static final boolean isNotEmpty(String text) {
        return !StringUtils.isEmpty(text);
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }
}

