/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.df.content;

import org.codelibs.elasticsearch.df.content.DataContent;
import org.codelibs.elasticsearch.df.content.csv.CsvContent;
import org.codelibs.elasticsearch.df.content.json.JsonContent;
import org.codelibs.elasticsearch.df.content.json.JsonListContent;
import org.codelibs.elasticsearch.df.content.xls.XlsContent;
import org.elasticsearch.client.Client;
import org.elasticsearch.rest.RestRequest;

public enum ContentType {
    CSV(10){

        @Override
        public String contentType() {
            return "text/csv";
        }

        @Override
        public DataContent dataContent(Client client, RestRequest request) {
            return new CsvContent(client, request, this);
        }

        @Override
        public String fileName(RestRequest request) {
            String index = request.param("index");
            if (index == null) {
                return "_all.csv";
            }
            return index + ".csv";
        }
    }
    ,
    EXCEL(20){

        @Override
        public String contentType() {
            return "application/vnd.ms-excel";
        }

        @Override
        public DataContent dataContent(Client client, RestRequest request) {
            return new XlsContent(client, request, this, false);
        }

        @Override
        public String fileName(RestRequest request) {
            String index = request.param("index");
            if (index == null) {
                return "_all.xls";
            }
            return index + ".xls";
        }
    }
    ,
    JSON(30){

        @Override
        public String contentType() {
            return "application/json";
        }

        @Override
        public DataContent dataContent(Client client, RestRequest request) {
            return new JsonContent(client, request, this);
        }

        @Override
        public String fileName(RestRequest request) {
            String index = request.param("index");
            if (index == null) {
                return "_all.json";
            }
            return index + ".json";
        }
    }
    ,
    EXCEL2007(40){

        @Override
        public String contentType() {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }

        @Override
        public DataContent dataContent(Client client, RestRequest request) {
            return new XlsContent(client, request, this, true);
        }

        @Override
        public String fileName(RestRequest request) {
            String index = request.param("index");
            if (index == null) {
                return "_all.xlsx";
            }
            return index + ".xlsx";
        }
    }
    ,
    JSONLIST(50){

        @Override
        public String contentType() {
            return "application/json";
        }

        @Override
        public DataContent dataContent(Client client, RestRequest request) {
            return new JsonListContent(client, request, this);
        }

        @Override
        public String fileName(RestRequest request) {
            String index = request.param("index");
            if (index == null) {
                return "_all.json";
            }
            return index + ".json";
        }
    };

    private int index;

    private ContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public abstract String contentType();

    public abstract DataContent dataContent(Client var1, RestRequest var2);

    public abstract String fileName(RestRequest var1);
}

