/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.df.content.csv;

import com.orangesignal.csv.CsvConfig;
import com.orangesignal.csv.CsvWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.elasticsearch.df.content.ContentType;
import org.codelibs.elasticsearch.df.content.DataContent;
import org.codelibs.elasticsearch.df.util.MapUtils;
import org.codelibs.elasticsearch.df.util.RequestUtil;
import org.codelibs.elasticsearch.df.util.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class CsvContent
extends DataContent {
    private static final Logger logger = LogManager.getLogger(CsvContent.class);
    private final String charsetName;
    private final CsvConfig csvConfig;
    private final boolean appendHeader;
    private Set<String> headerSet;
    private boolean modifiableFieldSet;

    public CsvContent(Client client, RestRequest request, ContentType contentType) {
        super(client, request, contentType);
        String[] fields;
        this.csvConfig = new CsvConfig(request.param("csv.separator", ",").charAt(0), request.param("csv.quote", "\"").charAt(0), request.param("csv.escape", "\"").charAt(0));
        this.csvConfig.setQuoteDisabled(request.paramAsBoolean("csv.quoteDisabled", false));
        this.csvConfig.setEscapeDisabled(request.paramAsBoolean("csv.escapeDisabled", false));
        this.csvConfig.setNullString(request.param("csv.nullString", ""));
        this.csvConfig.setIgnoreLeadingWhitespaces(request.paramAsBoolean("csv.ignoreLeadingWhitespaces", true));
        this.csvConfig.setIgnoreTrailingWhitespaces(request.paramAsBoolean("csv.ignoreTrailingWhitespaces", true));
        this.appendHeader = request.paramAsBoolean("append.header", true);
        this.charsetName = request.param("csv.encoding", "UTF-8");
        String fields_name = "fields_name";
        if (request.hasParam("fl")) {
            fields_name = "fl";
        }
        if ((fields = request.paramAsStringArray(fields_name, StringUtils.EMPTY_STRINGS)).length == 0) {
            this.headerSet = new LinkedHashSet<String>();
            this.modifiableFieldSet = true;
        } else {
            LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
            for (String field : fields) {
                fieldSet.add(field.trim());
            }
            this.headerSet = Collections.unmodifiableSet(fieldSet);
            this.modifiableFieldSet = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CsvConfig: {}, appendHeader: {}, charsetName: {}, headerSet: {}", (Object)this.csvConfig, (Object)this.appendHeader, (Object)this.charsetName, this.headerSet);
        }
    }

    @Override
    public void write(File outputFile, SearchResponse response, RestChannel channel, ActionListener<Void> listener) {
        try {
            OnLoadListener onLoadListener = new OnLoadListener(outputFile, listener);
            onLoadListener.onResponse(response);
        }
        catch (Exception e) {
            listener.onFailure((Exception)new ElasticsearchException("Failed to write data.", (Throwable)e, new Object[0]));
        }
    }

    protected class OnLoadListener
    implements ActionListener<SearchResponse> {
        protected ActionListener<Void> listener;
        protected CsvWriter csvWriter;
        protected File outputFile;
        private long currentCount = 0L;

        protected OnLoadListener(File outputFile, ActionListener<Void> listener) {
            this.outputFile = outputFile;
            this.listener = listener;
            try {
                this.csvWriter = new CsvWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), CsvContent.this.charsetName)), CsvContent.this.csvConfig);
            }
            catch (Exception e) {
                throw new ElasticsearchException("Could not open " + outputFile.getAbsolutePath(), (Throwable)e, new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(SearchResponse response) {
            block23: {
                String scrollId = response.getScrollId();
                SearchHits hits = response.getHits();
                int size = hits.getHits().length;
                this.currentCount += (long)size;
                if (logger.isDebugEnabled()) {
                    logger.debug("scrollId: {}, totalHits: {}, hits: {}, current: {}", (Object)scrollId, (Object)hits.getTotalHits(), (Object)size, (Object)this.currentCount);
                }
                try {
                    block24: {
                        for (SearchHit hit : hits) {
                            Map sourceMap = hit.getSourceAsMap();
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            MapUtils.convertToFlatMap("", sourceMap, dataMap);
                            for (String key : dataMap.keySet()) {
                                if (!CsvContent.this.modifiableFieldSet || CsvContent.this.headerSet.contains(key)) continue;
                                CsvContent.this.headerSet.add(key);
                            }
                            ArrayList<String> dataList = new ArrayList<String>(dataMap.size());
                            for (String name : CsvContent.this.headerSet) {
                                Object value = dataMap.get(name);
                                dataList.add(value != null ? value.toString() : null);
                            }
                            this.csvWriter.writeValues(dataList);
                        }
                        if (size != 0 && scrollId != null) break block24;
                        this.csvWriter.flush();
                        this.close();
                        if (CsvContent.this.appendHeader) {
                            Path tempFile;
                            block22: {
                                boolean finished = false;
                                tempFile = Files.createTempFile("dataformat_", ".csv", new FileAttribute[0]);
                                try {
                                    try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);
                                         CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out, CsvContent.this.charsetName), CsvContent.this.csvConfig);){
                                        writer.writeValues(CsvContent.this.headerSet.stream().collect(Collectors.toList()));
                                        writer.flush();
                                        Files.copy(this.outputFile.toPath(), out);
                                        finished = true;
                                    }
                                    if (!finished) break block22;
                                }
                                catch (Throwable throwable) {
                                    if (finished) {
                                        Files.copy(tempFile, this.outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    }
                                    Files.delete(tempFile);
                                    throw throwable;
                                }
                                Files.copy(tempFile, this.outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            Files.delete(tempFile);
                        }
                        this.listener.onResponse(null);
                        break block23;
                    }
                    CsvContent.this.client.prepareSearchScroll(scrollId).setScroll(RequestUtil.getScroll(CsvContent.this.request)).execute((ActionListener)this);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }
        }

        public void onFailure(Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listener.onFailure((Exception)new ElasticsearchException("Failed to write data.", (Throwable)e, new Object[0]));
        }

        private void close() {
            if (this.csvWriter != null) {
                try {
                    this.csvWriter.close();
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Could not close " + this.outputFile.getAbsolutePath(), (Throwable)e, new Object[0]);
                }
            }
        }
    }
}

