/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.df.content.json;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.elasticsearch.df.content.ContentType;
import org.codelibs.elasticsearch.df.content.DataContent;
import org.codelibs.elasticsearch.df.util.RequestUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class JsonListContent
extends DataContent {
    private static final Logger logger = LogManager.getLogger(JsonListContent.class);

    public JsonListContent(Client client, RestRequest request, ContentType contentType) {
        super(client, request, contentType);
    }

    @Override
    public void write(File outputFile, SearchResponse response, RestChannel channel, ActionListener<Void> listener) {
        try {
            OnLoadListener onLoadListener = new OnLoadListener(outputFile, listener);
            onLoadListener.onResponse(response);
        }
        catch (Exception e) {
            listener.onFailure((Exception)new ElasticsearchException("Failed to write data.", (Throwable)e, new Object[0]));
        }
    }

    protected class OnLoadListener
    implements ActionListener<SearchResponse> {
        protected ActionListener<Void> listener;
        protected Writer writer;
        protected File outputFile;
        private long currentCount = 0L;
        private boolean firstLine = true;

        protected OnLoadListener(File outputFile, ActionListener<Void> listener) {
            this.outputFile = outputFile;
            this.listener = listener;
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
            }
            catch (Exception e) {
                throw new ElasticsearchException("Could not open " + outputFile.getAbsolutePath(), (Throwable)e, new Object[0]);
            }
            try {
                this.writer.append('[');
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        public void onResponse(SearchResponse response) {
            String scrollId = response.getScrollId();
            SearchHits hits = response.getHits();
            int size = hits.getHits().length;
            this.currentCount += (long)size;
            if (logger.isDebugEnabled()) {
                logger.debug("scrollId: {}, totalHits: {}, hits: {}, current: {}", (Object)scrollId, (Object)hits.getTotalHits(), (Object)size, (Object)this.currentCount);
            }
            try {
                for (SearchHit hit : hits) {
                    String source = XContentHelper.convertToJson((BytesReference)hit.getSourceRef(), (boolean)true, (boolean)false, (XContentType)XContentType.JSON);
                    if (!this.firstLine) {
                        this.writer.append(',');
                    } else {
                        this.firstLine = false;
                    }
                    this.writer.append('\n').append(source);
                }
                if (size == 0 || scrollId == null) {
                    this.writer.append('\n').append(']');
                    this.writer.flush();
                    this.close();
                    this.listener.onResponse(null);
                } else {
                    JsonListContent.this.client.prepareSearchScroll(scrollId).setScroll(RequestUtil.getScroll(JsonListContent.this.request)).execute((ActionListener)this);
                }
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        public void onFailure(Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listener.onFailure((Exception)new ElasticsearchException("Failed to write data.", (Throwable)e, new Object[0]));
        }

        private void close() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Could not close " + this.outputFile.getAbsolutePath(), (Throwable)e, new Object[0]);
                }
            }
        }
    }
}

