/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.df.content.xls;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.codelibs.elasticsearch.df.content.ContentType;
import org.codelibs.elasticsearch.df.content.DataContent;
import org.codelibs.elasticsearch.df.util.MapUtils;
import org.codelibs.elasticsearch.df.util.RequestUtil;
import org.codelibs.elasticsearch.df.util.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class XlsContent
extends DataContent {
    private static final Logger logger = LogManager.getLogger(XlsContent.class);
    private static final int SXSSF_FLUSH_COUNT = 1000;
    private static final String DEFAULT_HEADER_COLUMN = "-";
    private final boolean appendHeader;
    private boolean headerFlushed = false;
    private Set<String> headerSet;
    private boolean modifiableFieldSet;
    private final boolean isExcel2007;

    public XlsContent(Client client, RestRequest request, ContentType contentType, boolean isExcel2007) {
        super(client, request, contentType);
        String[] fields;
        this.appendHeader = request.paramAsBoolean("append.header", true);
        String fieldsName = "fields_name";
        if (request.hasParam("fl")) {
            fieldsName = "fl";
        }
        if ((fields = request.paramAsStringArray(fieldsName, StringUtils.EMPTY_STRINGS)).length == 0) {
            this.headerSet = new LinkedHashSet<String>();
            this.modifiableFieldSet = true;
        } else {
            LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
            for (String field : fields) {
                fieldSet.add(field.trim());
            }
            this.headerSet = Collections.unmodifiableSet(fieldSet);
            this.modifiableFieldSet = false;
        }
        this.isExcel2007 = isExcel2007;
        if (logger.isDebugEnabled()) {
            logger.debug("appendHeader: {}, headerSet: {}, isExcel2007: {}", (Object)this.appendHeader, this.headerSet, (Object)isExcel2007);
        }
    }

    @Override
    public void write(File outputFile, SearchResponse response, RestChannel channel, ActionListener<Void> listener) {
        try {
            OnLoadListener onLoadListener = new OnLoadListener(outputFile, listener);
            onLoadListener.onResponse(response);
        }
        catch (Exception e) {
            listener.onFailure((Exception)new ElasticsearchException("Failed to write data.", (Throwable)e, new Object[0]));
        }
    }

    protected class OnLoadListener
    implements ActionListener<SearchResponse> {
        protected ActionListener<Void> listener;
        protected File outputFile;
        private Workbook workbook;
        private Sheet sheet;
        private int currentRowNumber = 0;

        protected OnLoadListener(File outputFile, ActionListener<Void> listener) {
            this.outputFile = outputFile;
            this.listener = listener;
            if (XlsContent.this.isExcel2007) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)new SpecialPermission());
                }
                this.workbook = AccessController.doPrivileged(() -> new SXSSFWorkbook(-1));
                this.sheet = AccessController.doPrivileged(() -> this.workbook.createSheet());
            } else {
                this.workbook = new HSSFWorkbook();
                this.sheet = this.workbook.createSheet();
            }
        }

        private void flushSheet(int currentCount, Sheet sheet) throws IOException {
            if (sheet instanceof SXSSFSheet && currentCount % 1000 == 0) {
                ((SXSSFSheet)sheet).flushRows(0);
            }
        }

        private void disposeWorkbook(Workbook workbook) {
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(SearchResponse response) {
            block21: {
                String scrollId = response.getScrollId();
                try {
                    SearchHits hits = response.getHits();
                    int size = hits.getHits().length;
                    if (logger.isDebugEnabled()) {
                        logger.debug("scrollId: {}, totalHits: {}, hits: {}, current: {}", (Object)scrollId, (Object)hits.getTotalHits(), (Object)size, (Object)(this.currentRowNumber + size));
                    }
                    for (SearchHit hit : hits) {
                        Map sourceMap = hit.getSourceAsMap();
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        MapUtils.convertToFlatMap("", sourceMap, dataMap);
                        for (String key : dataMap.keySet()) {
                            if (!XlsContent.this.modifiableFieldSet || XlsContent.this.headerSet.contains(key)) continue;
                            XlsContent.this.headerSet.add(key);
                        }
                        if (!XlsContent.this.headerFlushed && XlsContent.this.appendHeader) {
                            Row headerRow = this.sheet.createRow(0);
                            int count = 0;
                            for (String value : XlsContent.this.headerSet) {
                                Cell cell = headerRow.createCell(count);
                                cell.setCellValue(value);
                                ++count;
                            }
                            XlsContent.this.headerFlushed = true;
                        }
                        Row row = this.sheet.createRow(XlsContent.this.appendHeader ? this.currentRowNumber + 1 : this.currentRowNumber);
                        int count = 0;
                        for (String name : XlsContent.this.headerSet) {
                            Object value = dataMap.get(name);
                            Cell cell = row.createCell(count);
                            if (value != null && value.toString().trim().length() > 0) {
                                cell.setCellValue(value.toString());
                            } else {
                                cell.setCellValue(XlsContent.DEFAULT_HEADER_COLUMN);
                            }
                            ++count;
                        }
                        this.flushSheet(this.currentRowNumber, this.sheet);
                        ++this.currentRowNumber;
                    }
                    if (size == 0 || scrollId == null) {
                        this.flushSheet(0, this.sheet);
                        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.outputFile));){
                            SecurityManager sm = System.getSecurityManager();
                            if (sm != null) {
                                sm.checkPermission((Permission)new SpecialPermission());
                            }
                            AccessController.doPrivileged(() -> {
                                try {
                                    this.workbook.write(stream);
                                }
                                catch (IOException e) {
                                    throw new ElasticsearchException((Throwable)e);
                                }
                                return null;
                            });
                            ((OutputStream)stream).flush();
                        }
                        finally {
                            this.disposeWorkbook(this.workbook);
                        }
                        this.listener.onResponse(null);
                        break block21;
                    }
                    XlsContent.this.client.prepareSearchScroll(scrollId).setScroll(RequestUtil.getScroll(XlsContent.this.request)).execute((ActionListener)this);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }
        }

        public void onFailure(Exception e) {
            this.listener.onFailure((Exception)new ElasticsearchException("Failed to write data.", (Throwable)e, new Object[0]));
        }
    }
}

