/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.df.rest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.elasticsearch.df.content.ContentType;
import org.codelibs.elasticsearch.df.content.DataContent;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.search.RestSearchAction;

public class RestDataAction
extends BaseRestHandler {
    private static final float DEFAULT_LIMIT_PERCENTAGE = 10.0f;
    private static Logger logger = LogManager.getLogger(RestDataAction.class);
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private final long defaultLimit = (long)((float)this.maxMemory * 0.1f);

    public RestDataAction(Settings settings, RestController restController) {
        logger.info("Default limit: {}", (Object)this.defaultLimit);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_data"), new RestHandler.Route(RestRequest.Method.POST, "/_data"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_data"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_data")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        long limitBytes;
        SearchRequest searchRequest = new SearchRequest();
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, (XContentParser)parser, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), size -> searchRequest.source().size(size)));
        if (request.paramAsInt("size", -1) == -1) {
            searchRequest.source().size(100);
        }
        String file = request.param("file");
        String limitParamStr = request.param("limit");
        if (Strings.isNullOrEmpty((String)limitParamStr)) {
            limitBytes = this.defaultLimit;
        } else {
            if (limitParamStr.endsWith("%")) {
                limitParamStr = limitParamStr.substring(0, limitParamStr.length() - 1);
            }
            limitBytes = (long)((float)this.maxMemory * (Float.parseFloat(limitParamStr) / 100.0f));
        }
        ContentType contentType = this.getContentType(request);
        if (contentType == null) {
            String msg = "Unknown content type:" + request.header("Content-Type");
            throw new IllegalArgumentException(msg);
        }
        DataContent dataContent = contentType.dataContent((Client)client, request);
        return channel -> client.search(searchRequest, (ActionListener)new SearchResponseListener((RestChannel)channel, file, limitBytes, dataContent));
    }

    private ContentType getContentType(RestRequest request) {
        String contentType = request.param("format", request.header("Content-Type"));
        if (logger.isDebugEnabled()) {
            logger.debug("contentType: {}", (Object)contentType);
        }
        if ("text/csv".equals(contentType) || "text/comma-separated-values".equals(contentType) || "csv".equalsIgnoreCase(contentType)) {
            return ContentType.CSV;
        }
        if ("application/excel".equals(contentType) || "application/msexcel".equals(contentType) || "application/vnd.ms-excel".equals(contentType) || "application/x-excel".equals(contentType) || "application/x-msexcel".equals(contentType) || "xls".equalsIgnoreCase(contentType)) {
            return ContentType.EXCEL;
        }
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType) || "xlsx".equalsIgnoreCase(contentType)) {
            return ContentType.EXCEL2007;
        }
        if ("text/javascript".equals(contentType) || "application/json".equals(contentType) || "json".equalsIgnoreCase(contentType)) {
            return ContentType.JSON;
        }
        if ("application/list+json".equals(contentType) || "jsonlist".equals(contentType)) {
            return ContentType.JSONLIST;
        }
        return null;
    }

    public String getName() {
        return "data_download_action";
    }

    class SearchResponseListener
    implements ActionListener<SearchResponse> {
        private final RestChannel channel;
        private File outputFile;
        private final DataContent dataContent;
        private final long limit;

        SearchResponseListener(RestChannel channel, String file, long limit, DataContent dataContent) {
            this.channel = channel;
            this.dataContent = dataContent;
            if (!Strings.isNullOrEmpty((String)file)) {
                this.outputFile = new File(file);
                File parentFile = this.outputFile.getParentFile();
                if (parentFile != null && !parentFile.isDirectory()) {
                    throw new ElasticsearchException("Cannot create/access " + this.outputFile.getAbsolutePath(), new Object[0]);
                }
            }
            this.limit = limit;
        }

        public void onResponse(SearchResponse response) {
            try {
                boolean useLocalFile;
                boolean bl = useLocalFile = this.outputFile != null;
                if (this.outputFile == null) {
                    this.outputFile = File.createTempFile("es_df_output_", ".dat");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("outputFile: {}", (Object)this.outputFile.getAbsolutePath());
                }
                this.dataContent.write(this.outputFile, response, this.channel, new ActionListener<Void>(){

                    public void onResponse(Void response) {
                        try {
                            if (useLocalFile) {
                                SearchResponseListener.this.sendResponse(SearchResponseListener.this.dataContent.getRequest(), SearchResponseListener.this.channel, SearchResponseListener.this.outputFile.getAbsolutePath());
                            } else {
                                SearchResponseListener.this.writeResponse(SearchResponseListener.this.dataContent.getRequest(), SearchResponseListener.this.channel, SearchResponseListener.this.outputFile, SearchResponseListener.this.limit, SearchResponseListener.this.dataContent);
                                SearchResponseListener.this.deleteOutputFile();
                            }
                        }
                        catch (Exception e) {
                            this.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        SearchResponseListener.this.onFailure(e);
                    }
                });
            }
            catch (IOException e) {
                this.onFailure(e);
            }
        }

        private void deleteOutputFile() {
            if (this.outputFile != null && !this.outputFile.delete()) {
                logger.warn("Failed to delete: {}", (Object)this.outputFile.getAbsolutePath());
            }
        }

        public void onFailure(Exception e) {
            this.deleteOutputFile();
            try {
                this.channel.sendResponse((RestResponse)new BytesRestResponse(this.channel, RestStatus.INTERNAL_SERVER_ERROR, e));
            }
            catch (IOException e1) {
                logger.error("Failed to send failure response", (Throwable)e1);
            }
        }

        private void sendResponse(RestRequest request, RestChannel channel, String file) {
            try {
                XContentBuilder builder = JsonXContent.contentBuilder();
                String pretty = request.param("pretty");
                if (pretty != null && !"false".equalsIgnoreCase(pretty)) {
                    builder.prettyPrint().lfAtEnd();
                }
                builder.startObject();
                builder.field("acknowledged", true);
                builder.field("file", file);
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create a resposne.", (Throwable)e, new Object[0]);
            }
        }

        private void writeResponse(RestRequest request, RestChannel channel, File outputFile, long limit, DataContent dataContent) {
            if (outputFile.length() > limit) {
                this.onFailure((Exception)new ElasticsearchException("Content size is too large " + outputFile.length(), new Object[0]));
                return;
            }
            try (FileInputStream fis = new FileInputStream(outputFile);){
                int len;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((len = fis.read(bytes)) > 0) {
                    out.write(bytes, 0, len);
                }
                ContentType contentType = dataContent.getContentType();
                BytesRestResponse response = new BytesRestResponse(RestStatus.OK, contentType.contentType(), out.toByteArray());
                response.addHeader("Content-Disposition", "attachment; filename=\"" + contentType.fileName(request) + "\"");
                channel.sendResponse((RestResponse)response);
            }
            catch (Throwable e) {
                throw new ElasticsearchException("Failed to render the content.", e, new Object[0]);
            }
        }
    }
}

