/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.codelibs.elasticsearch.web.config.ScrapingRule;
import org.codelibs.robot.entity.ResponseData;
import org.elasticsearch.client.Client;
import org.elasticsearch.script.ScriptService;

public class RiverConfig {
    protected Client client;
    protected Map<String, List<ScrapingRule>> sessionScrapingRuleMap = new ConcurrentHashMap<String, List<ScrapingRule>>();
    protected Map<String, Map<String, Object>> riverParamMap = new ConcurrentHashMap<String, Map<String, Object>>();
    protected Map<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>();
    private ScriptService scriptService;

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void createLock(String sessionId) {
        this.lockMap.put(sessionId, new ReentrantLock());
    }

    public Lock getLock(String sessionId) {
        return this.lockMap.get(sessionId);
    }

    public void addRiverParams(String sessionId, Map<String, Object> paramMap) {
        this.riverParamMap.put(sessionId, paramMap);
    }

    private Map<String, Object> getRiverParameterMap(String sessionId) {
        return this.riverParamMap.get(sessionId);
    }

    public void addScrapingRule(String sessionId, Map<String, Object> settingMap, Map<String, Object> patternMap, Map<String, Map<String, Object>> scrapingRuleMap) {
        List<ScrapingRule> ruleList = this.getScrapingRuleList(sessionId);
        ruleList.add(new ScrapingRule(settingMap, patternMap, scrapingRuleMap));
    }

    private List<ScrapingRule> getScrapingRuleList(String sessionId) {
        List<ScrapingRule> scrapingRuleList = this.sessionScrapingRuleMap.get(sessionId);
        if (scrapingRuleList == null) {
            scrapingRuleList = new ArrayList<ScrapingRule>();
            this.sessionScrapingRuleMap.put(sessionId, scrapingRuleList);
        }
        return scrapingRuleList;
    }

    public ScrapingRule getScrapingRule(ResponseData responseData) {
        List<ScrapingRule> scrapingRuleList = this.getScrapingRuleList(responseData.getSessionId());
        for (ScrapingRule scrapingRule : scrapingRuleList) {
            if (!scrapingRule.matches(responseData)) continue;
            return scrapingRule;
        }
        return null;
    }

    public String getIndexName(String sessionId) {
        String indexName;
        Map<String, Object> paramMap = this.getRiverParameterMap(sessionId);
        if (paramMap != null && (indexName = (String)paramMap.get("index")) != null) {
            return indexName;
        }
        return null;
    }

    public String getTypeName(String sessionId) {
        String indexName;
        Map<String, Object> paramMap = this.getRiverParameterMap(sessionId);
        if (paramMap != null && (indexName = (String)paramMap.get("type")) != null) {
            return indexName;
        }
        return null;
    }

    public boolean isOverwrite(String sessionId) {
        Map<String, Object> paramMap = this.getRiverParameterMap(sessionId);
        if (paramMap != null) {
            Boolean overwrite = (Boolean)paramMap.get("overwrite");
            return overwrite != null && overwrite != false;
        }
        return false;
    }

    public boolean isIncremental(String sessionId) {
        Map<String, Object> paramMap = this.getRiverParameterMap(sessionId);
        if (paramMap != null) {
            Boolean overwrite = (Boolean)paramMap.get("incremental");
            return overwrite != null && overwrite != false;
        }
        return false;
    }

    public void cleanup(String sessionId) {
        this.riverParamMap.remove(sessionId);
        this.sessionScrapingRuleMap.remove(sessionId);
        this.lockMap.remove(sessionId);
    }
}

