/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.config;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codelibs.elasticsearch.util.settings.SettingsUtils;
import org.codelibs.robot.entity.ResponseData;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.FieldUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrapingRule {
    private static final Logger logger = LoggerFactory.getLogger(ScrapingRule.class);
    final Map<String, Pattern> patternMap = new LinkedHashMap<String, Pattern>();
    final Map<String, Object> settingMap;
    final Map<String, Map<String, Object>> ruleMap;

    public ScrapingRule(Map<String, Object> settingMap, Map<String, Object> paramPatternMap, Map<String, Map<String, Object>> ruleMap) {
        this.settingMap = settingMap == null ? Collections.emptyMap() : settingMap;
        this.ruleMap = ruleMap;
        for (Map.Entry<String, Object> entry : paramPatternMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            this.patternMap.put(entry.getKey(), Pattern.compile(value.toString()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("patternMap: " + this.patternMap);
        }
    }

    public boolean matches(ResponseData responseData) {
        if (this.patternMap.isEmpty()) {
            return false;
        }
        try {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(responseData.getClass());
            for (Map.Entry<String, Pattern> entry : this.patternMap.entrySet()) {
                Field field = beanDesc.getField(entry.getKey());
                Object value = FieldUtil.get((Field)field, (Object)responseData);
                if (value != null && entry.getValue().matcher(value.toString()).matches()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("Invalid parameters: " + responseData, (Throwable)e);
            return false;
        }
    }

    public Map<String, Map<String, Object>> getRuleMap() {
        return this.ruleMap;
    }

    public <T, V> T getSetting(String key, T defaultValue) {
        return (T)SettingsUtils.get(this.settingMap, (String)key, defaultValue);
    }
}

