/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.river;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMScheme;
import org.codelibs.elasticsearch.quartz.service.ScheduleService;
import org.codelibs.elasticsearch.util.lang.StringUtils;
import org.codelibs.elasticsearch.util.settings.SettingsUtils;
import org.codelibs.elasticsearch.web.config.RiverConfig;
import org.codelibs.elasticsearch.web.robot.interval.WebRiverIntervalController;
import org.codelibs.elasticsearch.web.robot.service.EsDataService;
import org.codelibs.elasticsearch.web.robot.service.EsUrlFilterService;
import org.codelibs.elasticsearch.web.robot.service.EsUrlQueueService;
import org.codelibs.robot.S2Robot;
import org.codelibs.robot.S2RobotContext;
import org.codelibs.robot.client.http.Authentication;
import org.codelibs.robot.client.http.RequestHeader;
import org.codelibs.robot.client.http.impl.AuthenticationImpl;
import org.codelibs.robot.client.http.ntlm.JcifsEngine;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.river.AbstractRiverComponent;
import org.elasticsearch.river.River;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.RiverSettings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class WebRiver
extends AbstractRiverComponent
implements River {
    private static final ESLogger logger = Loggers.getLogger(WebRiver.class);
    private static final String RIVER_NAME = "riverName";
    private static final String SETTINGS = "settings";
    private static final String RUNNING_JOB = "runningJob";
    private static final String SCRIPT_SERVICE = "scriptService";
    private static final String TRIGGER_ID_SUFFIX = "Trigger";
    private static final String JOB_ID_SUFFIX = "Job";
    private static final String ES_CLIENT = "esClient";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Elasticsearch River Web/1.1.2)";
    private static final String NTLM_SCHEME = "NTLM";
    private static final String DIGEST_SCHEME = "DIGEST";
    private static final String BASIC_SCHEME = "BASIC";
    private static final String ONE_TIME = "oneTime";
    private static final String EMPTY_STRING = "";
    private final Client client;
    private final ScheduleService scheduleService;
    private String groupId;
    private String id;
    private AtomicReference<CrawlJob> runningJob = new AtomicReference();
    private ScriptService scriptService;

    @Inject
    public WebRiver(RiverName riverName, RiverSettings settings, Client client, ScheduleService scheduleService, ScriptService scriptService) {
        super(riverName, settings);
        this.client = client;
        this.scheduleService = scheduleService;
        this.scriptService = scriptService;
        this.groupId = riverName.type() == null ? "web" : riverName.type();
        this.id = riverName.name();
        logger.info("Creating WebRiver: " + this.id, new Object[0]);
    }

    public void start() {
        logger.info("Scheduling CrawlJob...", new Object[0]);
        if (this.scheduleService == null) {
            logger.warn("Elasticsearch River Web plugin depends on Elasticsearch Quartz plugin, but it's not found. River Web plugin does not start.", new Object[0]);
            return;
        }
        JobDataMap jobDataMap = new JobDataMap();
        String cron = null;
        Map scheduleSettings = (Map)this.settings.settings().get("schedule");
        if (scheduleSettings != null) {
            cron = (String)scheduleSettings.get("cron");
        }
        if (cron == null) {
            Date now = new Date();
            now = DateUtils.addSeconds((Date)now, (int)60);
            SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
            cron = sdf.format(now);
            jobDataMap.put(ONE_TIME, (Object)Boolean.TRUE);
        }
        jobDataMap.put(RIVER_NAME, (Object)this.riverName);
        jobDataMap.put(SETTINGS, (Object)this.settings);
        jobDataMap.put(ES_CLIENT, (Object)this.client);
        jobDataMap.put(RUNNING_JOB, this.runningJob);
        jobDataMap.put(SCRIPT_SERVICE, (Object)this.scriptService);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put(RIVER_NAME, this.riverName);
        vars.put("client", this.client);
        WebRiver.executeScript(this.scriptService, this.settings.settings(), vars, "start");
        JobDetail crawlJob = JobBuilder.newJob(CrawlJob.class).withIdentity(this.id + JOB_ID_SUFFIX, this.groupId).usingJobData(jobDataMap).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.id + TRIGGER_ID_SUFFIX, this.groupId).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).startNow().build();
        this.scheduleService.scheduleJob(crawlJob, trigger);
    }

    public void close() {
        if (this.scheduleService == null) {
            return;
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put(RIVER_NAME, this.riverName);
        vars.put("client", this.client);
        WebRiver.executeScript(this.scriptService, this.settings.settings(), vars, "close");
        logger.info("Unscheduling  CrawlJob...", new Object[0]);
        CrawlJob crawlJob = this.runningJob.get();
        if (crawlJob != null) {
            crawlJob.stop();
        }
        this.scheduleService.deleteJob(JobKey.jobKey((String)(this.id + JOB_ID_SUFFIX), (String)this.groupId));
    }

    protected static void executeScript(ScriptService scriptService, Map<String, Object> settings, Map<String, Object> vars, String target) {
        Map crawlSettings = (Map)SettingsUtils.get(settings, (String)"crawl");
        Map scriptSettings = (Map)SettingsUtils.get((Map)crawlSettings, (String)"script");
        String script = (String)SettingsUtils.get((Map)scriptSettings, (String)target);
        String lang = (String)SettingsUtils.get((Map)scriptSettings, (String)"lang", (Object)"groovy");
        String scriptTypeValue = (String)SettingsUtils.get((Map)scriptSettings, (String)"script_type", (Object)"inline");
        ScriptService.ScriptType scriptType = ScriptService.ScriptType.FILE.toString().equalsIgnoreCase(scriptTypeValue) ? ScriptService.ScriptType.FILE : (ScriptService.ScriptType.INDEXED.toString().equalsIgnoreCase(scriptTypeValue) ? ScriptService.ScriptType.INDEXED : ScriptService.ScriptType.INLINE);
        if (StringUtils.isNotBlank((String)script)) {
            HashMap<String, Object> localVars = new HashMap<String, Object>(vars);
            localVars.put("container", SingletonS2ContainerFactory.getContainer());
            localVars.put(SETTINGS, settings);
            try {
                CompiledScript compiledScript = scriptService.compile(lang, script, scriptType);
                ExecutableScript executable = scriptService.executable(compiledScript, localVars);
                Object result = executable.run();
                logger.info("[{}] \"{}\" => {}", new Object[]{target, script, result});
            }
            catch (Exception e) {
                logger.warn("Failed to execute script: {}", (Throwable)e, new Object[]{script});
            }
        }
    }

    public static class CrawlJob
    implements Job {
        private S2Robot s2Robot;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecutionContext context) throws JobExecutionException {
            List urlList;
            List targetList;
            Map crawlSettings;
            Map rootSettings;
            RiverConfig riverConfig;
            HashMap<String, Object> vars;
            Client client;
            String sessionId;
            RiverName riverName;
            ScriptService scriptSerivce;
            AtomicReference runningJob;
            JobDataMap data;
            block61: {
                List headerList;
                List authList;
                Object host;
                block60: {
                    block59: {
                        data = context.getMergedJobDataMap();
                        runningJob = (AtomicReference)data.get((Object)WebRiver.RUNNING_JOB);
                        scriptSerivce = (ScriptService)data.get((Object)WebRiver.SCRIPT_SERVICE);
                        if (!runningJob.compareAndSet(null, this)) {
                            logger.info(context.getJobDetail().getKey() + " is running.", new Object[0]);
                            return;
                        }
                        riverName = (RiverName)data.get((Object)WebRiver.RIVER_NAME);
                        sessionId = UUID.randomUUID().toString();
                        client = this.getClient(data);
                        vars = new HashMap<String, Object>();
                        vars.put(WebRiver.RIVER_NAME, riverName);
                        vars.put("sessionId", sessionId);
                        vars.put("client", client);
                        riverConfig = null;
                        RiverSettings settings = (RiverSettings)data.get((Object)WebRiver.SETTINGS);
                        rootSettings = settings.settings();
                        WebRiver.executeScript(scriptSerivce, rootSettings, vars, "execute");
                        crawlSettings = (Map)rootSettings.get("crawl");
                        if (crawlSettings != null) break block59;
                        logger.warn("No settings for crawling.", new Object[0]);
                        WebRiver.executeScript(scriptSerivce, rootSettings, vars, "finish");
                        runningJob.set(null);
                        if (riverConfig != null) {
                            riverConfig.cleanup(sessionId);
                        }
                        try {
                            ((EsUrlQueueService)SingletonS2Container.getComponent(EsUrlQueueService.class)).delete(sessionId);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to delete ", (Throwable)e, new Object[0]);
                        }
                        ((EsDataService)SingletonS2Container.getComponent(EsDataService.class)).delete(sessionId);
                        ((EsUrlFilterService)SingletonS2Container.getComponent(EsUrlFilterService.class)).delete(sessionId);
                        Object oneTime = data.get((Object)WebRiver.ONE_TIME);
                        if (oneTime != null && client != null) {
                            DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)client.admin().indices().prepareDeleteMapping(new String[]{"_river"}).setType(new String[]{riverName.name()}).execute().actionGet();
                            if (deleteMappingResponse.isAcknowledged()) {
                                logger.info("Deleted one time river: " + riverName.name(), new Object[0]);
                            } else {
                                logger.warn("Failed to delete " + riverName.name() + ". Resposne: " + deleteMappingResponse.toString(), new Object[0]);
                            }
                        }
                        return;
                    }
                    targetList = (List)crawlSettings.get("target");
                    if (targetList != null && !targetList.isEmpty()) break block60;
                    logger.warn("No targets for crawling.", new Object[0]);
                    WebRiver.executeScript(scriptSerivce, rootSettings, vars, "finish");
                    runningJob.set(null);
                    if (riverConfig != null) {
                        riverConfig.cleanup(sessionId);
                    }
                    try {
                        ((EsUrlQueueService)SingletonS2Container.getComponent(EsUrlQueueService.class)).delete(sessionId);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to delete ", (Throwable)e, new Object[0]);
                    }
                    ((EsDataService)SingletonS2Container.getComponent(EsDataService.class)).delete(sessionId);
                    ((EsUrlFilterService)SingletonS2Container.getComponent(EsUrlFilterService.class)).delete(sessionId);
                    Object oneTime = data.get((Object)WebRiver.ONE_TIME);
                    if (oneTime != null && client != null) {
                        DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)client.admin().indices().prepareDeleteMapping(new String[]{"_river"}).setType(new String[]{riverName.name()}).execute().actionGet();
                        if (deleteMappingResponse.isAcknowledged()) {
                            logger.info("Deleted one time river: " + riverName.name(), new Object[0]);
                        } else {
                            logger.warn("Failed to delete " + riverName.name() + ". Resposne: " + deleteMappingResponse.toString(), new Object[0]);
                        }
                    }
                    return;
                }
                this.s2Robot = (S2Robot)SingletonS2Container.getComponent(S2Robot.class);
                this.s2Robot.setSessionId(sessionId);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                this.s2Robot.getClientFactory().setInitParameterMap(paramMap);
                String userAgent = (String)SettingsUtils.get((Map)crawlSettings, (String)"userAgent", (Object)WebRiver.DEFAULT_USER_AGENT);
                if (StringUtil.isNotBlank((String)userAgent)) {
                    paramMap.put("userAgent", userAgent);
                }
                Boolean robotsTxtEnabled = (Boolean)SettingsUtils.get((Map)crawlSettings, (String)"robotsTxt", (Object)Boolean.TRUE);
                paramMap.put("robotsTxtEnabled", robotsTxtEnabled);
                Map proxyMap = (Map)SettingsUtils.get((Map)crawlSettings, (String)"proxy", null);
                if (proxyMap != null && (host = proxyMap.get("host")) != null) {
                    paramMap.put("proxyHost", host);
                    Object portObj = proxyMap.get("port");
                    if (portObj instanceof Integer) {
                        paramMap.put("proxyPort", portObj);
                    } else {
                        paramMap.put("proxyPort", 8080);
                    }
                }
                if ((authList = (List)SettingsUtils.get((Map)crawlSettings, (String)"authentications", null)) != null && !authList.isEmpty()) {
                    ArrayList<AuthenticationImpl> basicAuthList = new ArrayList<AuthenticationImpl>();
                    for (Object authObj : authList) {
                        Map scopeMap = (Map)authObj.get("scope");
                        String scheme = ((String)SettingsUtils.get((Map)scopeMap, (String)"scheme", (Object)WebRiver.EMPTY_STRING)).toUpperCase(Locale.ENGLISH);
                        if (StringUtil.isBlank((String)scheme)) {
                            logger.warn("Invalid authentication: " + authObj, new Object[0]);
                            continue;
                        }
                        Map credentialMap = (Map)authObj.get("credentials");
                        String username = (String)SettingsUtils.get((Map)credentialMap, (String)"username", null);
                        if (StringUtil.isBlank((String)username)) {
                            logger.warn("Invalid authentication: " + authObj, new Object[0]);
                            continue;
                        }
                        String host2 = (String)SettingsUtils.get((Map)authObj, (String)"host", (Object)AuthScope.ANY_HOST);
                        int port = (Integer)SettingsUtils.get((Map)authObj, (String)"port", (Object)-1);
                        String realm = (String)SettingsUtils.get((Map)authObj, (String)"realm", (Object)AuthScope.ANY_REALM);
                        String password = (String)SettingsUtils.get((Map)credentialMap, (String)"password", null);
                        BasicScheme authScheme = null;
                        UsernamePasswordCredentials credentials = null;
                        if (WebRiver.BASIC_SCHEME.equalsIgnoreCase(scheme)) {
                            authScheme = new BasicScheme();
                            credentials = new UsernamePasswordCredentials(username, password);
                        } else if (WebRiver.DIGEST_SCHEME.equals(scheme)) {
                            authScheme = new DigestScheme();
                            credentials = new UsernamePasswordCredentials(username, password);
                        } else if (WebRiver.NTLM_SCHEME.equals(scheme)) {
                            authScheme = new NTLMScheme((NTLMEngine)new JcifsEngine());
                            scheme = AuthScope.ANY_SCHEME;
                            String workstation = (String)SettingsUtils.get((Map)credentialMap, (String)"workstation", null);
                            String domain = (String)SettingsUtils.get((Map)credentialMap, (String)"domain", null);
                            credentials = new NTCredentials(username, password, workstation == null ? WebRiver.EMPTY_STRING : workstation, domain == null ? WebRiver.EMPTY_STRING : domain);
                        }
                        AuthenticationImpl auth = new AuthenticationImpl(new AuthScope(host2, port, realm, scheme), (Credentials)credentials, (AuthScheme)authScheme);
                        basicAuthList.add(auth);
                    }
                    paramMap.put("basicAuthentications", basicAuthList.toArray(new Authentication[basicAuthList.size()]));
                }
                if ((headerList = (List)SettingsUtils.get((Map)crawlSettings, (String)"headers", null)) != null && !headerList.isEmpty()) {
                    ArrayList<RequestHeader> requestHeaderList = new ArrayList<RequestHeader>();
                    for (Map headerObj : headerList) {
                        String name = (String)SettingsUtils.get((Map)headerObj, (String)"name", null);
                        String value = (String)SettingsUtils.get((Map)headerObj, (String)"value", null);
                        if (name == null || value == null) continue;
                        requestHeaderList.add(new RequestHeader(name, value));
                    }
                    paramMap.put("requestHeaders", requestHeaderList.toArray(new RequestHeader[requestHeaderList.size()]));
                }
                if ((urlList = (List)crawlSettings.get("url")) != null && !urlList.isEmpty()) break block61;
                logger.warn("No url for crawling.", new Object[0]);
                WebRiver.executeScript(scriptSerivce, rootSettings, vars, "finish");
                runningJob.set(null);
                if (riverConfig != null) {
                    riverConfig.cleanup(sessionId);
                }
                try {
                    ((EsUrlQueueService)SingletonS2Container.getComponent(EsUrlQueueService.class)).delete(sessionId);
                }
                catch (Exception e) {
                    logger.warn("Failed to delete ", (Throwable)e, new Object[0]);
                }
                ((EsDataService)SingletonS2Container.getComponent(EsDataService.class)).delete(sessionId);
                ((EsUrlFilterService)SingletonS2Container.getComponent(EsUrlFilterService.class)).delete(sessionId);
                Object oneTime = data.get((Object)WebRiver.ONE_TIME);
                if (oneTime != null && client != null) {
                    DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)client.admin().indices().prepareDeleteMapping(new String[]{"_river"}).setType(new String[]{riverName.name()}).execute().actionGet();
                    if (deleteMappingResponse.isAcknowledged()) {
                        logger.info("Deleted one time river: " + riverName.name(), new Object[0]);
                    } else {
                        logger.warn("Failed to delete " + riverName.name() + ". Resposne: " + deleteMappingResponse.toString(), new Object[0]);
                    }
                }
                return;
            }
            try {
                List excludeFilterList;
                for (Object url : urlList) {
                    this.s2Robot.addUrl((String)url);
                }
                List includeFilterList = (List)crawlSettings.get("includeFilter");
                if (includeFilterList != null) {
                    for (Object regex : includeFilterList) {
                        this.s2Robot.addIncludeFilter((String)regex);
                    }
                }
                if ((excludeFilterList = (List)crawlSettings.get("excludeFilter")) != null) {
                    for (String regex : excludeFilterList) {
                        this.s2Robot.addExcludeFilter(regex);
                    }
                }
                S2RobotContext robotContext = this.s2Robot.getRobotContext();
                int maxDepth = (Integer)SettingsUtils.get((Map)crawlSettings, (String)"maxDepth", (Object)-1);
                robotContext.setMaxDepth(maxDepth);
                int maxAccessCount = (Integer)SettingsUtils.get((Map)crawlSettings, (String)"maxAccessCount", (Object)100);
                robotContext.setMaxAccessCount((long)maxAccessCount);
                int numOfThread = (Integer)SettingsUtils.get((Map)crawlSettings, (String)"numOfThread", (Object)5);
                robotContext.setNumOfThread(numOfThread);
                long interval = ((Integer)SettingsUtils.get((Map)crawlSettings, (String)"interval", (Object)1000)).intValue();
                WebRiverIntervalController intervalController = (WebRiverIntervalController)this.s2Robot.getIntervalController();
                intervalController.setDelayMillisForWaitingNewUrl(interval);
                HashMap<String, Object> riverParamMap = new HashMap<String, Object>();
                riverParamMap.put("index", SettingsUtils.get((Map)crawlSettings, (String)"index", (Object)"web"));
                riverParamMap.put("type", SettingsUtils.get((Map)crawlSettings, (String)"type", (Object)riverName.getName()));
                riverParamMap.put("overwrite", SettingsUtils.get((Map)crawlSettings, (String)"overwrite", (Object)Boolean.FALSE));
                riverParamMap.put("incremental", SettingsUtils.get((Map)crawlSettings, (String)"incremental", (Object)Boolean.FALSE));
                riverConfig = (RiverConfig)SingletonS2Container.getComponent(RiverConfig.class);
                riverConfig.createLock(sessionId);
                riverConfig.addRiverParams(sessionId, riverParamMap);
                for (Map targetMap : targetList) {
                    Map patternMap = (Map)targetMap.get("pattern");
                    Map propMap = (Map)targetMap.get("properties");
                    if (patternMap != null && propMap != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("patternMap: " + patternMap, new Object[0]);
                            logger.debug("propMap: " + propMap, new Object[0]);
                        }
                        Map settingMap = (Map)targetMap.get(WebRiver.SETTINGS);
                        riverConfig.addScrapingRule(sessionId, settingMap, patternMap, propMap);
                        continue;
                    }
                    logger.warn("Invalid pattern or target: patternMap: " + patternMap + ", propMap: " + propMap, new Object[0]);
                }
                this.s2Robot.execute();
                this.s2Robot.stop();
            }
            catch (Throwable throwable) {
                WebRiver.executeScript(scriptSerivce, rootSettings, vars, "finish");
                runningJob.set(null);
                if (riverConfig != null) {
                    riverConfig.cleanup(sessionId);
                }
                try {
                    ((EsUrlQueueService)SingletonS2Container.getComponent(EsUrlQueueService.class)).delete(sessionId);
                }
                catch (Exception e) {
                    logger.warn("Failed to delete ", (Throwable)e, new Object[0]);
                }
                ((EsDataService)SingletonS2Container.getComponent(EsDataService.class)).delete(sessionId);
                ((EsUrlFilterService)SingletonS2Container.getComponent(EsUrlFilterService.class)).delete(sessionId);
                Object oneTime = data.get((Object)WebRiver.ONE_TIME);
                if (oneTime != null && client != null) {
                    DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)client.admin().indices().prepareDeleteMapping(new String[]{"_river"}).setType(new String[]{riverName.name()}).execute().actionGet();
                    if (deleteMappingResponse.isAcknowledged()) {
                        logger.info("Deleted one time river: " + riverName.name(), new Object[0]);
                    } else {
                        logger.warn("Failed to delete " + riverName.name() + ". Resposne: " + deleteMappingResponse.toString(), new Object[0]);
                    }
                }
                throw throwable;
            }
            WebRiver.executeScript(scriptSerivce, rootSettings, vars, "finish");
            runningJob.set(null);
            if (riverConfig != null) {
                riverConfig.cleanup(sessionId);
            }
            try {
                ((EsUrlQueueService)SingletonS2Container.getComponent(EsUrlQueueService.class)).delete(sessionId);
            }
            catch (Exception e) {
                logger.warn("Failed to delete ", (Throwable)e, new Object[0]);
            }
            ((EsDataService)SingletonS2Container.getComponent(EsDataService.class)).delete(sessionId);
            ((EsUrlFilterService)SingletonS2Container.getComponent(EsUrlFilterService.class)).delete(sessionId);
            Object oneTime = data.get((Object)WebRiver.ONE_TIME);
            if (oneTime != null && client != null) {
                DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)client.admin().indices().prepareDeleteMapping(new String[]{"_river"}).setType(new String[]{riverName.name()}).execute().actionGet();
                if (deleteMappingResponse.isAcknowledged()) {
                    logger.info("Deleted one time river: " + riverName.name(), new Object[0]);
                } else {
                    logger.warn("Failed to delete " + riverName.name() + ". Resposne: " + deleteMappingResponse.toString(), new Object[0]);
                }
            }
        }

        private Client getClient(JobDataMap data) {
            Object clientObj = data.get((Object)WebRiver.ES_CLIENT);
            if (clientObj instanceof Client) {
                return (Client)clientObj;
            }
            return null;
        }

        public void stop() {
            if (this.s2Robot != null) {
                this.s2Robot.stop();
            }
        }
    }
}

