/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.robot.service;

import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.codelibs.elasticsearch.web.config.RiverConfig;
import org.codelibs.robot.RobotSystemException;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.beans.util.CreateAndCopy;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractRobotService {
    private static final String ID_SEPARATOR = ".";
    private static final Base64 base64 = new Base64(Integer.MAX_VALUE, new byte[0], true);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected static final String SESSION_ID = "sessionId";
    protected static final String URL = "url";
    protected static final String LAST_MODIFIED = "lastModified";
    protected static final String CREATE_TIME = "createTime";
    protected static final String[] timestampFields = new String[]{"lastModified", "createTime"};
    protected String index;
    protected String type;
    @Resource
    protected RiverConfig riverConfig;

    protected XContentBuilder getXContentBuilder(Object target) {
        try {
            return XContentFactory.jsonBuilder().value(target);
        }
        catch (IOException e) {
            throw new RobotSystemException("Failed to convert " + target + " to JSON.", (Throwable)e);
        }
    }

    protected void refresh() {
        this.riverConfig.getClient().admin().indices().prepareRefresh(new String[]{this.index}).execute().actionGet();
    }

    protected void insert(Object target, IndexRequest.OpType opType) {
        String id = this.getId(this.getSessionId(target), this.getUrl(target));
        XContentBuilder source = this.getXContentBuilder(target);
        this.riverConfig.getClient().prepareIndex(this.index, this.type, id).setSource(source).setOpType(opType).setRefresh(true).execute().actionGet();
    }

    protected <T> void insertAll(List<T> list, IndexRequest.OpType opType) {
        BulkRequestBuilder bulkRequest = this.riverConfig.getClient().prepareBulk();
        for (T target : list) {
            String id = this.getId(this.getSessionId(target), this.getUrl(target));
            XContentBuilder source = this.getXContentBuilder(target);
            bulkRequest.add(this.riverConfig.getClient().prepareIndex(this.index, this.type, id).setSource(source).setOpType(opType));
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.setRefresh(true).execute().actionGet();
        if (bulkResponse.hasFailures()) {
            throw new RobotSystemException(bulkResponse.buildFailureMessage());
        }
    }

    protected boolean exists(String sessionId, String url) {
        String id = this.getId(sessionId, url);
        GetResponse response = (GetResponse)this.riverConfig.getClient().prepareGet(this.index, this.type, id).setRefresh(true).execute().actionGet();
        return response.isExists();
    }

    protected <T> T get(Class<T> clazz, String sessionId, String url) {
        String id = this.getId(sessionId, url);
        GetResponse response = (GetResponse)this.riverConfig.getClient().prepareGet(this.index, this.type, id).execute().actionGet();
        if (response.isExists()) {
            return (T)((CreateAndCopy)((CreateAndCopy)Beans.createAndCopy(clazz, (Object)response.getSource()).converter((Converter)new EsTimestampConverter(), (CharSequence[])timestampFields)).excludesWhitespace()).execute();
        }
        return null;
    }

    protected <T> List<T> getList(Class<T> clazz, String sessionId, QueryBuilder queryBuilder, Integer from, Integer size, SortBuilder sortBuilder) {
        ArrayList<Object> targetList = new ArrayList<Object>();
        SearchResponse response = this.getSearchResponse(sessionId, queryBuilder, from, size, sortBuilder);
        SearchHits hits = response.getHits();
        if (hits.getTotalHits() != 0L) {
            try {
                for (SearchHit searchHit : hits.getHits()) {
                    targetList.add(((CreateAndCopy)((CreateAndCopy)Beans.createAndCopy(clazz, (Object)searchHit.getSource()).converter((Converter)new EsTimestampConverter(), (CharSequence[])timestampFields)).excludesWhitespace()).execute());
                }
            }
            catch (Exception e) {
                throw new RobotSystemException("response: " + response, (Throwable)e);
            }
        }
        return targetList;
    }

    protected void delete(String sessionId, String url) {
        String id = this.getId(sessionId, url);
        this.riverConfig.getClient().prepareDelete(this.index, this.type, id).setRefresh(true).execute().actionGet();
    }

    protected void deleteBySessionId(String sessionId) {
        this.riverConfig.getClient().prepareDeleteByQuery(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)QueryBuilders.queryString((String)("sessionId:" + sessionId))).execute().actionGet();
        this.refresh();
    }

    public void deleteAll() {
        this.riverConfig.getClient().prepareDeleteByQuery(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        this.refresh();
    }

    private SearchResponse getSearchResponse(String sessionId, QueryBuilder queryBuilder, Integer from, Integer size, SortBuilder sortBuilder) {
        SearchRequestBuilder builder = this.riverConfig.getClient().prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type});
        if (StringUtil.isNotBlank((String)sessionId)) {
            builder.setPostFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.queryString((String)("sessionId:" + sessionId))));
        }
        if (queryBuilder != null) {
            builder.setQuery(queryBuilder);
        } else {
            builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (sortBuilder != null) {
            builder.addSort(sortBuilder);
        }
        if (from != null) {
            builder.setFrom(from.intValue());
        }
        if (size != null) {
            builder.setSize(size.intValue());
        }
        SearchResponse response = (SearchResponse)builder.execute().actionGet();
        return response;
    }

    private String getId(String sessionId, String url) {
        return sessionId + ID_SEPARATOR + new String(base64.encode(url.getBytes(UTF_8)), UTF_8);
    }

    private String getUrl(Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc sessionIdProp = beanDesc.getPropertyDesc(URL);
        Object sessionId = sessionIdProp.getValue(target);
        return sessionId == null ? null : sessionId.toString();
    }

    private String getSessionId(Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc sessionIdProp = beanDesc.getPropertyDesc(SESSION_ID);
        Object sessionId = sessionIdProp.getValue(target);
        return sessionId == null ? null : sessionId.toString();
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected static class EsTimestampConverter
    implements Converter {
        protected EsTimestampConverter() {
        }

        public String getAsString(Object value) {
            if (value instanceof Date) {
                return XContentBuilder.defaultDatePrinter.print(((Date)value).getTime());
            }
            return null;
        }

        public Object getAsObject(String value) {
            if (StringUtil.isEmpty((String)value)) {
                return null;
            }
            return new Timestamp(XContentBuilder.defaultDatePrinter.parseMillis(value));
        }

        public boolean isTarget(Class clazz) {
            return clazz == Date.class;
        }
    }
}

