/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.robot.service;

import java.util.ArrayList;
import java.util.List;
import org.codelibs.elasticsearch.web.robot.entity.EsAccessResult;
import org.codelibs.elasticsearch.web.robot.service.AbstractRobotService;
import org.codelibs.robot.entity.AccessResult;
import org.codelibs.robot.service.DataService;
import org.codelibs.robot.util.AccessResultCallback;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.seasar.framework.beans.Converter;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.beans.util.CreateAndCopy;

public class EsDataService
extends AbstractRobotService
implements DataService {
    public int scrollTimeout = 60000;
    public int scrollSize = 100;

    public void store(AccessResult accessResult) {
        super.insert(accessResult, IndexRequest.OpType.CREATE);
    }

    public void update(AccessResult accessResult) {
        this.store(accessResult);
    }

    public void update(List<AccessResult> accessResultList) {
        this.insertAll(accessResultList, IndexRequest.OpType.INDEX);
    }

    public int getCount(String sessionId) {
        return (int)((CountResponse)this.riverConfig.getClient().prepareCount(new String[]{this.index}).setTypes(new String[]{sessionId}).execute().actionGet()).getCount();
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public AccessResult getAccessResult(String sessionId, String url) {
        return this.get(AccessResult.class, sessionId, url);
    }

    public List<AccessResult> getAccessResultList(String url, boolean hasData) {
        SearchResponse response = (SearchResponse)this.riverConfig.getClient().prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"url", (String)url)).execute().actionGet();
        SearchHits hits = response.getHits();
        ArrayList<AccessResult> accessResultList = new ArrayList<AccessResult>();
        if (hits.getTotalHits() != 0L) {
            for (SearchHit searchHit : hits.getHits()) {
                accessResultList.add((AccessResult)((CreateAndCopy)((CreateAndCopy)Beans.createAndCopy(EsAccessResult.class, (Object)searchHit.getSource()).converter((Converter)new AbstractRobotService.EsTimestampConverter(), (CharSequence[])timestampFields)).excludesWhitespace()).execute());
            }
        }
        return accessResultList;
    }

    public void iterate(String sessionId, AccessResultCallback callback) {
        SearchResponse response = (SearchResponse)this.riverConfig.getClient().prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setSearchType(SearchType.SCAN).setScroll(new TimeValue((long)this.scrollTimeout)).setPostFilter((FilterBuilder)FilterBuilders.termFilter((String)"sessionId", (String)sessionId)).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(this.scrollSize).execute().actionGet();
        while (true) {
            SearchHits searchHits = response.getHits();
            for (SearchHit searchHit : searchHits) {
                AccessResult accessResult = (AccessResult)((CreateAndCopy)((CreateAndCopy)Beans.createAndCopy(EsAccessResult.class, (Object)searchHit.getSource()).converter((Converter)new AbstractRobotService.EsTimestampConverter(), (CharSequence[])timestampFields)).excludesWhitespace()).execute();
                callback.iterate(accessResult);
            }
            if (searchHits.hits().length == 0) break;
            response = (SearchResponse)this.riverConfig.getClient().prepareSearchScroll(response.getScrollId()).setScroll(new TimeValue((long)this.scrollTimeout)).execute().actionGet();
        }
    }

    public void iterateUrlDiff(String oldSessionId, String newSessionId, AccessResultCallback accessResultCallback) {
        throw new UnsupportedOperationException("Unsupported.");
    }
}

