/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.robot.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.codelibs.elasticsearch.web.robot.service.AbstractRobotService;
import org.codelibs.robot.service.UrlFilterService;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class EsUrlFilterService
extends AbstractRobotService
implements UrlFilterService {
    private static final String FILTER_TYPE = "filterType";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";

    public void addIncludeUrlFilter(String sessionId, String url) {
        EsUrlFilter esUrlFilter = new EsUrlFilter();
        esUrlFilter.setSessionId(sessionId);
        esUrlFilter.setFilterType(INCLUDE);
        esUrlFilter.setUrl(url);
        this.insert(esUrlFilter, IndexRequest.OpType.CREATE);
    }

    public void addIncludeUrlFilter(String sessionId, List<String> urlList) {
        ArrayList<EsUrlFilter> urlFilterList = new ArrayList<EsUrlFilter>(urlList.size());
        for (String url : urlList) {
            EsUrlFilter esUrlFilter = new EsUrlFilter();
            esUrlFilter.setSessionId(sessionId);
            esUrlFilter.setFilterType(INCLUDE);
            esUrlFilter.setUrl(url);
            urlFilterList.add(esUrlFilter);
        }
        this.insertAll(urlFilterList, IndexRequest.OpType.CREATE);
    }

    public void addExcludeUrlFilter(String sessionId, String url) {
        EsUrlFilter esUrlFilter = new EsUrlFilter();
        esUrlFilter.setSessionId(sessionId);
        esUrlFilter.setFilterType(EXCLUDE);
        esUrlFilter.setUrl(url);
        this.insert(esUrlFilter, IndexRequest.OpType.CREATE);
    }

    public void addExcludeUrlFilter(String sessionId, List<String> urlList) {
        ArrayList<EsUrlFilter> urlFilterList = new ArrayList<EsUrlFilter>(urlList.size());
        for (String url : urlList) {
            EsUrlFilter esUrlFilter = new EsUrlFilter();
            esUrlFilter.setSessionId(sessionId);
            esUrlFilter.setFilterType(EXCLUDE);
            esUrlFilter.setUrl(url);
            urlFilterList.add(esUrlFilter);
        }
        this.insertAll(urlFilterList, IndexRequest.OpType.CREATE);
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        List<EsUrlFilter> urlFilterList = this.getList(EsUrlFilter.class, sessionId, (QueryBuilder)QueryBuilders.termQuery((String)FILTER_TYPE, (String)INCLUDE), null, null, null);
        ArrayList<Pattern> urlPatternList = new ArrayList<Pattern>();
        for (EsUrlFilter esUrlFilter : urlFilterList) {
            urlPatternList.add(Pattern.compile(esUrlFilter.getUrl()));
        }
        return urlPatternList;
    }

    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        List<EsUrlFilter> urlFilterList = this.getList(EsUrlFilter.class, sessionId, (QueryBuilder)QueryBuilders.termQuery((String)FILTER_TYPE, (String)EXCLUDE), null, null, null);
        ArrayList<Pattern> urlPatternList = new ArrayList<Pattern>();
        for (EsUrlFilter esUrlFilter : urlFilterList) {
            urlPatternList.add(Pattern.compile(esUrlFilter.getUrl()));
        }
        return urlPatternList;
    }

    public static class EsUrlFilter
    implements ToXContent {
        private String sessionId;
        private String filterType;
        private String url;

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getFilterType() {
            return this.filterType;
        }

        public void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.sessionId != null) {
                builder.field("sessionId", this.sessionId);
            }
            if (this.filterType != null) {
                builder.field(EsUrlFilterService.FILTER_TYPE, this.filterType);
            }
            if (this.url != null) {
                builder.field("url", this.url);
            }
            builder.endObject();
            return builder;
        }
    }
}

