/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.robot.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import org.codelibs.elasticsearch.web.robot.entity.EsUrlQueue;
import org.codelibs.elasticsearch.web.robot.service.AbstractRobotService;
import org.codelibs.elasticsearch.web.robot.service.EsDataService;
import org.codelibs.robot.entity.AccessResult;
import org.codelibs.robot.entity.UrlQueue;
import org.codelibs.robot.service.UrlQueueService;
import org.codelibs.robot.util.AccessResultCallback;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.seasar.framework.util.StringUtil;

public class EsUrlQueueService
extends AbstractRobotService
implements UrlQueueService {
    private static final ESLogger logger = Loggers.getLogger(EsUrlQueueService.class);
    @Resource
    protected EsDataService dataService;
    protected Queue<UrlQueue> crawlingUrlQueue = new ConcurrentLinkedQueue<UrlQueue>();
    public int pollingFetchSize = 20;
    public int maxCrawlingQueueSize = 100;

    public void updateSessionId(String oldSessionId, String newSessionId) {
    }

    public void add(String sessionId, String url) {
        EsUrlQueue urlQueue = new EsUrlQueue();
        urlQueue.setSessionId(sessionId);
        urlQueue.setUrl(url);
        urlQueue.setCreateTime(new Timestamp(System.currentTimeMillis()));
        urlQueue.setLastModified(new Timestamp(0L));
        urlQueue.setDepth(0);
        urlQueue.setMethod("GET");
        this.insert((UrlQueue)urlQueue);
    }

    public void insert(UrlQueue urlQueue) {
        super.insert(urlQueue, IndexRequest.OpType.CREATE);
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public void offerAll(String sessionId, List<UrlQueue> urlQueueList) {
        if (logger.isDebugEnabled()) {
            logger.debug("Offering URL: Session ID: {}, UrlQueue: {}", new Object[]{sessionId, urlQueueList});
        }
        ArrayList<UrlQueue> targetList = new ArrayList<UrlQueue>(urlQueueList.size());
        for (UrlQueue urlQueue : urlQueueList) {
            if (!this.exists(sessionId, urlQueue.getUrl()) && !this.dataService.exists(sessionId, urlQueue.getUrl())) {
                urlQueue.setSessionId(sessionId);
                targetList.add(urlQueue);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Existed URL: Session ID: {}, UrlQueue: {}", new Object[]{sessionId, urlQueue});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Offered URL: Session ID: {}, UrlQueue: {}", new Object[]{sessionId, targetList});
        }
        if (!targetList.isEmpty()) {
            this.insertAll(targetList, IndexRequest.OpType.CREATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlQueue poll(String sessionId) {
        Lock lock = this.riverConfig.getLock(sessionId);
        if (lock == null) {
            return null;
        }
        try {
            lock.lock();
            List<EsUrlQueue> urlQueueList = this.getList(EsUrlQueue.class, sessionId, null, 0, this.pollingFetchSize, (SortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.ASC));
            if (urlQueueList.isEmpty()) {
                UrlQueue urlQueue = null;
                return urlQueue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Queued URL: {}", new Object[]{urlQueueList});
            }
            Client client = this.riverConfig.getClient();
            for (EsUrlQueue urlQueue : urlQueueList) {
                String url = urlQueue.getUrl();
                if (this.exists(sessionId, url)) {
                    this.crawlingUrlQueue.add((UrlQueue)urlQueue);
                    if (this.crawlingUrlQueue.size() > this.maxCrawlingQueueSize) {
                        this.crawlingUrlQueue.poll();
                    }
                    super.delete(sessionId, url);
                    if (this.riverConfig.isIncremental(sessionId)) {
                        this.updateLastModified(sessionId, client, urlQueue, url);
                    }
                    EsUrlQueue esUrlQueue = urlQueue;
                    return esUrlQueue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Already Deleted: {}", new Object[]{urlQueue});
            }
            Iterator<EsUrlQueue> iterator = null;
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    private void updateLastModified(String sessionId, Client client, EsUrlQueue urlQueue, String url) {
        block3: {
            try {
                SearchHit hit;
                Map sourceMap;
                Date date;
                SearchResponse response = (SearchResponse)client.prepareSearch(new String[]{this.riverConfig.getIndexName(sessionId)}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"url", (String)url)).addSort((SortBuilder)SortBuilders.fieldSort((String)"lastModified").order(SortOrder.DESC)).setFrom(0).setSize(1).execute().actionGet();
                SearchHits hits = response.getHits();
                if (hits.getTotalHits() > 0L && (date = (Date)(sourceMap = (hit = hits.getHits()[0]).getSource()).get("lastModified")) != null) {
                    urlQueue.setLastModified(new Timestamp(date.getTime()));
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Failed to update a last modified: " + sessionId, (Throwable)e, new Object[0]);
            }
        }
    }

    public void saveSession(String sessionId) {
    }

    public boolean visited(UrlQueue urlQueue) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: " + url, new Object[0]);
            }
            return false;
        }
        String sessionId = urlQueue.getSessionId();
        if (super.exists(sessionId, url)) {
            return true;
        }
        AccessResult accessResult = this.dataService.getAccessResult(sessionId, url);
        return accessResult != null;
    }

    @Override
    protected boolean exists(String sessionId, String url) {
        boolean ret = super.exists(sessionId, url);
        if (!ret) {
            for (UrlQueue urlQueue : this.crawlingUrlQueue) {
                if (!sessionId.equals(urlQueue.getSessionId()) || !url.equals(urlQueue.getUrl())) continue;
                return true;
            }
        }
        return ret;
    }

    public void generateUrlQueues(String previousSessionId, final String sessionId) {
        this.dataService.iterate(previousSessionId, new AccessResultCallback(){

            public void iterate(AccessResult accessResult) {
                EsUrlQueue urlQueue = new EsUrlQueue();
                urlQueue.setSessionId(sessionId);
                urlQueue.setMethod(accessResult.getMethod());
                urlQueue.setUrl(accessResult.getUrl());
                urlQueue.setParentUrl(accessResult.getParentUrl());
                urlQueue.setDepth(0);
                urlQueue.setLastModified(accessResult.getLastModified());
                urlQueue.setCreateTime(new Timestamp(System.currentTimeMillis()));
                EsUrlQueueService.this.insert((UrlQueue)urlQueue);
            }
        });
    }
}

