/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.web.service;

import java.io.IOException;
import org.codelibs.elasticsearch.web.config.RiverConfig;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.script.ScriptService;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class S2ContainerService
extends AbstractLifecycleComponent<S2ContainerService> {
    private static final ESLogger logger = Loggers.getLogger(S2ContainerService.class);
    private Client client;
    private ScriptService scriptService;

    @Inject
    public S2ContainerService(Settings settings, final Client client, ClusterService clusterService, ScriptService scriptService) {
        super(settings);
        this.client = client;
        this.scriptService = scriptService;
        logger.info("Creating S2Container...", new Object[0]);
        SingletonS2ContainerFactory.init();
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
            }

            public void beforeStart() {
            }

            public void beforeClose() {
            }

            public void afterStop() {
            }

            public void afterStart() {
                client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute((ActionListener)new ActionListener<ClusterHealthResponse>(){

                    public void onResponse(ClusterHealthResponse response) {
                        if (response.getStatus() == ClusterHealthStatus.RED) {
                            logger.warn("The cluster is not available. The status is RED.", new Object[0]);
                        } else {
                            String robotIndexName = (String)SingletonS2Container.getComponent((String)"robotIndexName");
                            S2ContainerService.this.checkRobotIndex(robotIndexName);
                        }
                    }

                    public void onFailure(Throwable e) {
                        logger.warn("The cluster is not available.", e, new Object[0]);
                    }
                });
            }

            public void afterClose() {
            }
        });
    }

    protected void doStart() throws ElasticsearchException {
        logger.info("Starting S2Container...", new Object[0]);
        RiverConfig riverConfig = (RiverConfig)SingletonS2Container.getComponent(RiverConfig.class);
        riverConfig.setClient(this.client);
        riverConfig.setScriptService(this.scriptService);
    }

    private void checkRobotIndex(final String robotIndexName) {
        this.client.admin().indices().prepareExists(new String[]{robotIndexName}).execute((ActionListener)new ActionListener<IndicesExistsResponse>(){

            public void onResponse(IndicesExistsResponse response) {
                if (response.isExists()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} index exists.", new Object[]{robotIndexName});
                    }
                } else {
                    S2ContainerService.this.createRobotIndex(robotIndexName);
                }
            }

            public void onFailure(Throwable e) {
                if (e instanceof IndexMissingException) {
                    S2ContainerService.this.createRobotIndex(robotIndexName);
                } else {
                    logger.warn("The state of {} index is invalid.", e, new Object[]{robotIndexName});
                }
            }
        });
    }

    private void createRobotIndex(final String robotIndexName) {
        this.client.admin().indices().prepareCreate(robotIndexName).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse response) {
                if (response.isAcknowledged()) {
                    try {
                        S2ContainerService.this.createQueueMapping(robotIndexName);
                    }
                    catch (IOException e) {
                        logger.error("Failed to create queue mapping.", (Throwable)e, new Object[0]);
                    }
                } else {
                    logger.warn("Failed to create {}.", new Object[]{robotIndexName});
                }
            }

            public void onFailure(Throwable e) {
                logger.warn("Failed to create {}", e, new Object[]{robotIndexName});
            }
        });
    }

    private void createQueueMapping(final String robotIndexName) throws IOException {
        String type = "queue";
        this.createMapping(robotIndexName, "queue", this.createQueueMappingBuilder(), new ActionListener<PutMappingResponse>(){

            public void onResponse(PutMappingResponse response) {
                if (response.isAcknowledged()) {
                    try {
                        S2ContainerService.this.createFilterMapping(robotIndexName);
                    }
                    catch (IOException e) {
                        logger.error("Failed to create filter mapping.", (Throwable)e, new Object[0]);
                    }
                } else {
                    logger.warn("Failed to create {} mapping.", new Object[]{"queue"});
                }
            }

            public void onFailure(Throwable e) {
                logger.warn("Failed to create {} mapping.", e, new Object[]{"queue"});
            }
        });
    }

    private void createFilterMapping(final String robotIndexName) throws IOException {
        String type = "filter";
        this.createMapping(robotIndexName, "filter", this.createFilterMappingBuilder(), new ActionListener<PutMappingResponse>(){

            public void onResponse(PutMappingResponse response) {
                if (response.isAcknowledged()) {
                    try {
                        S2ContainerService.this.createDataMapping(robotIndexName);
                    }
                    catch (IOException e) {
                        logger.error("Failed to create data mapping.", (Throwable)e, new Object[0]);
                    }
                } else {
                    logger.warn("Failed to create {} mapping.", new Object[]{"filter"});
                }
            }

            public void onFailure(Throwable e) {
                logger.warn("Failed to create {} mapping.", e, new Object[]{"filter"});
            }
        });
    }

    private void createDataMapping(final String robotIndexName) throws IOException {
        String type = "data";
        this.createMapping(robotIndexName, "data", this.createDataMappingBuilder(), new ActionListener<PutMappingResponse>(){

            public void onResponse(PutMappingResponse response) {
                if (response.isAcknowledged()) {
                    logger.info("Create an index and mapping for {}.", new Object[]{robotIndexName});
                } else {
                    logger.warn("Failed to create {} mapping.", new Object[]{"data"});
                }
            }

            public void onFailure(Throwable e) {
                logger.warn("Failed to create {} mapping.", e, new Object[]{"data"});
            }
        });
    }

    private void createMapping(String robotIndexName, String type, XContentBuilder builder, ActionListener<PutMappingResponse> listener) {
        this.client.admin().indices().preparePutMapping(new String[]{robotIndexName}).setType(type).setSource(builder).execute(listener);
    }

    private XContentBuilder createQueueMappingBuilder() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject("queue").startObject("properties").startObject("createTime").field("type", "date").field("format", "dateOptionalTime").endObject().startObject("depth").field("type", "long").endObject().startObject("lastModified").field("type", "date").field("format", "dateOptionalTime").endObject().startObject("method").field("type", "string").field("index", "not_analyzed").endObject().startObject("parentUrl").field("type", "string").field("index", "not_analyzed").endObject().startObject("sessionId").field("type", "string").field("index", "not_analyzed").endObject().startObject("url").field("type", "string").field("index", "not_analyzed").endObject().endObject().endObject().endObject();
    }

    private XContentBuilder createFilterMappingBuilder() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject("filter").startObject("properties").startObject("filterType").field("type", "string").field("index", "not_analyzed").endObject().startObject("sessionId").field("type", "string").field("index", "not_analyzed").endObject().startObject("url").field("type", "string").field("index", "not_analyzed").endObject().endObject().endObject().endObject();
    }

    private XContentBuilder createDataMappingBuilder() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject("data").startObject("properties").startObject("contentLength").field("type", "long").endObject().startObject("createTime").field("type", "date").field("format", "dateOptionalTime").endObject().startObject("executionTime").field("type", "long").endObject().startObject("httpStatusCode").field("type", "long").endObject().startObject("lastModified").field("type", "date").field("format", "dateOptionalTime").endObject().startObject("method").field("type", "string").field("index", "not_analyzed").endObject().startObject("mimeType").field("type", "string").field("index", "not_analyzed").endObject().startObject("parentUrl").field("type", "string").field("index", "not_analyzed").endObject().startObject("ruleId").field("type", "string").field("index", "not_analyzed").endObject().startObject("sessionId").field("type", "string").field("index", "not_analyzed").endObject().startObject("status").field("type", "long").endObject().startObject("url").field("type", "string").field("index", "not_analyzed").endObject().startObject("accessResultData").startObject("properties").startObject("transformerName").field("type", "string").field("index", "not_analyzed").endObject().endObject().endObject().endObject().endObject().endObject();
    }

    protected void doStop() throws ElasticsearchException {
        logger.info("Stopping S2Container...", new Object[0]);
    }

    protected void doClose() throws ElasticsearchException {
        logger.info("Closing S2Container...", new Object[0]);
        SingletonS2ContainerFactory.destroy();
    }
}

