/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.guava.common.base;

import java.lang.ref.WeakReference;
import org.codelibs.elasticsearch.solr.guava.common.annotations.GwtCompatible;
import org.codelibs.elasticsearch.solr.guava.common.base.CharMatcher;
import org.codelibs.elasticsearch.solr.guava.common.base.Enums;
import org.codelibs.elasticsearch.solr.guava.common.base.Optional;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        return ref == null ? Optional.absent() : Optional.of(enumClass.cast(ref.get()));
    }
}

