/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.guava.common.collect;

import org.codelibs.elasticsearch.solr.guava.common.annotations.GwtCompatible;
import org.codelibs.elasticsearch.solr.guava.common.annotations.GwtIncompatible;
import org.codelibs.elasticsearch.solr.guava.common.collect.ImmutableAsList;
import org.codelibs.elasticsearch.solr.guava.common.collect.ImmutableCollection;
import org.codelibs.elasticsearch.solr.guava.common.collect.ImmutableList;
import org.codelibs.elasticsearch.solr.guava.common.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible(value="not present in emulated superclass")
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

