/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.rest;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestRequest;

public class ExtendedRestRequest
extends RestRequest {
    private static ESLogger logger = ESLoggerFactory.getLogger((String)ExtendedRestRequest.class.getName());
    private RestRequest parent;
    private volatile Map<String, List<String>> paramMap;

    public ExtendedRestRequest(RestRequest request) {
        this.parent = request;
    }

    private String getPath(String uri) {
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            return uri;
        }
        return uri.substring(0, pathEndPos);
    }

    private Map<String, List<String>> decodeParams(String s, String charset) {
        int i;
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        char c = '\u0000';
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = this.decodeComponent(s.substring(pos, i), charset);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (name == null && pos != i) {
                ExtendedRestRequest.addParam(params, this.decodeComponent(s.substring(pos, i), charset), "");
            } else if (name != null) {
                ExtendedRestRequest.addParam(params, name, this.decodeComponent(s.substring(pos, i), charset));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                ExtendedRestRequest.addParam(params, this.decodeComponent(s.substring(pos, i), charset), "");
            } else {
                ExtendedRestRequest.addParam(params, name, this.decodeComponent(s.substring(pos, i), charset));
            }
        } else if (name != null) {
            ExtendedRestRequest.addParam(params, name, "");
        }
        return params;
    }

    private String decodeComponent(String s, String charset) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, charset);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to decode {} by {}", new Object[]{s, charset});
            }
            return s;
        }
    }

    private static void addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
    }

    public String param(String key, String defaultValue) {
        List<String> list = this.getParameterMap().get(key);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return defaultValue;
    }

    public RestRequest.Method method() {
        return this.parent.method();
    }

    public String uri() {
        return this.parent.uri();
    }

    public String rawPath() {
        return this.parent.rawPath();
    }

    public boolean hasContent() {
        return this.parent.hasContent();
    }

    public boolean contentUnsafe() {
        return this.parent.contentUnsafe();
    }

    public BytesReference content() {
        return this.parent.content();
    }

    public String header(String name) {
        return this.parent.header(name);
    }

    public Iterable<Map.Entry<String, String>> headers() {
        return this.parent.headers();
    }

    public boolean hasParam(String key) {
        return this.getParameterMap().containsKey(key);
    }

    public String param(String key) {
        return this.param(key, null);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        List<String> list = this.getParameterMap().get(key);
        if (list != null) {
            if (list.size() == 1) {
                return Strings.splitStringByCommaToArray((String)list.get(0));
            }
            return list.toArray(new String[list.size()]);
        }
        return defaultValue;
    }

    public float paramAsFloat(String key, float defaultValue) {
        String value = this.param(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchIllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + value + "]", (Throwable)e);
        }
    }

    public int paramAsInt(String key, int defaultValue) {
        String value = this.param(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchIllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + value + "]", (Throwable)e);
        }
    }

    public long paramAsLong(String key, long defaultValue) {
        String value = this.param(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchIllegalArgumentException("Failed to parse long parameter [" + key + "] with value [" + value + "]", (Throwable)e);
        }
    }

    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String value = this.param(key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchIllegalArgumentException("Failed to parse boolean parameter [" + key + "] with value [" + value + "]", (Throwable)e);
        }
    }

    public Boolean paramAsBooleanOptional(String key, Boolean defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        return !"false".equals(sValue) && !"0".equals(sValue) && !"off".equals(sValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.param(key), (TimeValue)defaultValue);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue((String)this.param(key), (ByteSizeValue)defaultValue);
    }

    public Map<String, String> params() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.getParameterMap().entrySet()) {
            List<String> valueList = entry.getValue();
            if (valueList != null) {
                StringBuilder buf = new StringBuilder();
                for (String value : valueList) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append(value);
                }
                map.put(entry.getKey(), buf.toString());
                continue;
            }
            map.put(entry.getKey(), null);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getParameterMap() {
        if (this.paramMap == null) {
            ExtendedRestRequest extendedRestRequest = this;
            synchronized (extendedRestRequest) {
                this.initParameterMap();
            }
        }
        return this.paramMap;
    }

    private boolean isAppendPostData(String contentType) {
        if (contentType == null) {
            return true;
        }
        return contentType.indexOf("application/javabin") < 0 && contentType.indexOf("application/xml") < 0;
    }

    private void initParameterMap() {
        Map<String, List<String>> requestParamMap;
        boolean isPost;
        StringBuilder uriBuf = new StringBuilder(200);
        uriBuf.append(this.parent.uri());
        boolean bl = isPost = this.parent.method() == RestRequest.Method.POST;
        if (isPost && this.isAppendPostData(this.parent.header("Content-Type"))) {
            if (this.parent.uri().indexOf(63) >= 0) {
                uriBuf.append('&');
            } else {
                uriBuf.append('?');
            }
            uriBuf.append(this.parent.content().toUtf8());
        }
        String uri = uriBuf.toString();
        int pathLength = this.getPath(uri).length();
        if (uri.length() == pathLength) {
            requestParamMap = new LinkedHashMap<String, List<String>>();
        } else {
            String charset = this.parent.header("Accept-Charset");
            if (charset == null) {
                charset = "UTF-8";
            }
            requestParamMap = this.decodeParams(uri.substring(pathLength + 1), charset);
        }
        for (Map.Entry entry : this.parent.params().entrySet()) {
            if (requestParamMap.containsKey(entry.getKey())) continue;
            ArrayList list = new ArrayList(1);
            list.add(entry.getValue());
            requestParamMap.put((String)entry.getKey(), list);
        }
        this.paramMap = requestParamMap;
    }
}

