/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.rest;

import java.io.IOException;
import org.apache.commons.codec.Charsets;
import org.codelibs.elasticsearch.solr.guava.common.io.BaseEncoding;
import org.codelibs.elasticsearch.solr.rest.ExtendedRestRequest;
import org.codelibs.elasticsearch.solr.solr.SolrResponseUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryFilterBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class SolrSearchRestAction
extends BaseRestHandler {
    private final String defaultIndexName;
    private final String defaultTypeName;
    private final boolean lowercaseExpandedTerms;
    private final boolean autoGeneratePhraseQueries;

    @Inject
    public SolrSearchRestAction(Settings settings, Client client, RestController restController) {
        super(settings, restController, client);
        this.defaultIndexName = settings.get("solr.default.index", "solr");
        this.defaultTypeName = settings.get("solr.default.type", "docs");
        this.lowercaseExpandedTerms = settings.getAsBoolean("solr.lowercaseExpandedTerms", Boolean.valueOf(false));
        this.autoGeneratePhraseQueries = settings.getAsBoolean("solr.autoGeneratePhraseQueries", Boolean.valueOf(true));
        restController.registerHandler(RestRequest.Method.GET, "/_solr/select", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/{index}/_solr/select", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_solr/select", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/_solr/select", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/{index}/_solr/select", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_solr/select", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, final RestChannel channel, Client client) {
        final ExtendedRestRequest requestEx = new ExtendedRestRequest(request);
        SearchRequest searchRequest = this.getSearchRequest(requestEx);
        searchRequest.listenerThreaded(false);
        client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    SolrResponseUtils.writeResponse(SolrResponseUtils.createSearchResponse(requestEx, response), requestEx, channel);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable t) {
                SolrSearchRestAction.this.logger.error("Error processing executing search", t, new Object[0]);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, t));
                }
                catch (IOException e) {
                    SolrSearchRestAction.this.logger.error("Failed to send failure response", (Throwable)e, new Object[0]);
                }
            }
        });
    }

    private SearchRequest getSearchRequest(RestRequest request) {
        String q = request.param("q", null);
        int start = request.paramAsInt("start", 0);
        int rows = request.paramAsInt("rows", 10);
        FilteredQueryBuilder fl = request.paramAsStringArray("fl", Strings.EMPTY_ARRAY);
        FilteredQueryBuilder sort = request.paramAsStringArray("sort", Strings.EMPTY_ARRAY);
        String[] fqs = request.paramAsStringArray("fq", Strings.EMPTY_ARRAY);
        boolean hl = request.paramAsBoolean("hl", false);
        boolean facet = request.paramAsBoolean("facet", false);
        boolean trackScores = request.paramAsBoolean("track_scores", false);
        String debug = request.param("debug");
        boolean qDsl = request.paramAsBoolean("q.dsl", false);
        boolean fqDsl = request.paramAsBoolean("fq.dsl", false);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (q != null) {
            if (qDsl) {
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)q));
            } else {
                FilteredQueryBuilder queryBuilder;
                if (fqs.length > 0) {
                    QueryFilterBuilder filterBuilder = null;
                    if (fqs.length > 1) {
                        AndFilterBuilder fqAnd = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
                        for (String fq : fqs) {
                            fqAnd.add((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)(fqDsl ? QueryBuilders.wrapperQuery((String)fq) : QueryBuilders.queryString((String)fq))));
                        }
                        filterBuilder = fqAnd;
                    } else {
                        filterBuilder = FilterBuilders.queryFilter((QueryBuilder)(fqDsl ? QueryBuilders.wrapperQuery((String)fqs[0]) : QueryBuilders.queryString((String)fqs[0])));
                    }
                    queryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.queryString((String)q).lowercaseExpandedTerms(this.lowercaseExpandedTerms).autoGeneratePhraseQueries(this.autoGeneratePhraseQueries), (FilterBuilder)filterBuilder);
                } else {
                    queryBuilder = QueryBuilders.queryString((String)q).lowercaseExpandedTerms(this.lowercaseExpandedTerms).autoGeneratePhraseQueries(this.autoGeneratePhraseQueries);
                }
                searchSourceBuilder.query((QueryBuilder)queryBuilder);
            }
        }
        searchSourceBuilder.from(start);
        searchSourceBuilder.size(rows);
        if (((String[])fl).length > 0) {
            for (String field : fl) {
                if (!Strings.hasText((String)field)) continue;
                searchSourceBuilder.fields(new String[]{field.trim()});
            }
        }
        if (((String[])sort).length > 0) {
            for (String s : sort) {
                String sortStr = s.trim();
                int delimiter = sortStr.lastIndexOf(32);
                if (delimiter != -1) {
                    String reverse;
                    String sortField = sortStr.substring(0, delimiter);
                    if ("score".equals(sortField)) {
                        sortField = "_score";
                    }
                    if ("asc".equals(reverse = sortStr.substring(delimiter + 1))) {
                        searchSourceBuilder.sort((SortBuilder)SortBuilders.fieldSort((String)sortField).order(SortOrder.ASC).ignoreUnmapped(true));
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort((SortBuilder)SortBuilders.fieldSort((String)sortField).order(SortOrder.DESC).ignoreUnmapped(true));
                    continue;
                }
                searchSourceBuilder.sort((SortBuilder)SortBuilders.fieldSort((String)sortStr).ignoreUnmapped(true));
            }
        } else {
            searchSourceBuilder.sort("_score", SortOrder.DESC);
        }
        if (hl) {
            String hlfl = request.param("hl.fl", null);
            int hlsnippets = request.paramAsInt("hl.snippets", 1);
            int hlfragsize = request.paramAsInt("hl.fragsize", 100);
            String[] hlTagPre = request.param("hl.tag.pre", request.param("hl.simple.pre", null));
            String hlTagPost = request.param("hl.tag.post", request.param("hl.simple.post", null));
            int requireFieldMatch = request.paramAsBoolean("hl.requireFieldMatch", false) ? 1 : 0;
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            if (hlfl == null) {
                highlightBuilder.field("_all", hlfragsize, hlsnippets);
            } else {
                String[] hlfls;
                for (String hlField : hlfls = hlfl.split("\\s|,")) {
                    if (hlField.contains("*")) continue;
                    highlightBuilder.field(hlField, hlfragsize, hlsnippets);
                }
            }
            if (hlTagPre != null) {
                highlightBuilder.preTags(new String[]{hlTagPre});
            }
            if (hlTagPost != null) {
                highlightBuilder.postTags(new String[]{hlTagPost});
            }
            highlightBuilder.requireFieldMatch(requireFieldMatch != 0);
            searchSourceBuilder.highlight(highlightBuilder);
        }
        if (facet) {
            String[] facetQueries;
            String[] facetFields = request.paramAsStringArray("facet.field", new String[0]);
            String facetSort = request.param("facet.sort", null);
            int facetLimit = request.paramAsInt("facet.limit", 100);
            if (facetLimit < 0) {
                facetLimit = Integer.MAX_VALUE;
            }
            if (facetFields.length > 0) {
                for (String facetField : facetFields) {
                    Terms.Order order = facetSort != null && "index".equals(facetSort) ? Terms.Order.term((boolean)true) : Terms.Order.count((boolean)false);
                    String encodedField = BaseEncoding.base64().encode(facetField.getBytes(Charsets.UTF_8));
                    TermsBuilder termsBuilder = ((TermsBuilder)AggregationBuilders.terms((String)("facet_field_" + encodedField)).field(facetField)).size(facetLimit).order(order);
                    searchSourceBuilder.aggregation((AbstractAggregationBuilder)termsBuilder);
                }
            }
            if ((facetQueries = request.paramAsStringArray("facet.query", new String[0])).length > 0) {
                for (int i = 0; i < facetQueries.length; ++i) {
                    String facetQuery = facetQueries[i];
                    String encodedFacetQuery = BaseEncoding.base64().encode(facetQuery.getBytes(Charsets.UTF_8));
                    FilterAggregationBuilder filterAggregationBuilder = AggregationBuilders.filter((String)("facet_query_" + i + '_' + encodedFacetQuery)).filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.queryString((String)facetQuery)));
                    searchSourceBuilder.aggregation((AbstractAggregationBuilder)filterAggregationBuilder);
                }
            }
        }
        searchSourceBuilder.trackScores(trackScores);
        if ("true".equalsIgnoreCase(debug) || "query".equalsIgnoreCase(debug) || "timing".equalsIgnoreCase(debug) || "results".equalsIgnoreCase(debug)) {
            searchSourceBuilder.explain(Boolean.valueOf(true));
        }
        String index = request.param("index", this.defaultIndexName);
        String type = request.param("type", this.defaultTypeName);
        String[] indices = Strings.splitStringByCommaToArray((String)index);
        SearchRequest searchRequest = new SearchRequest(indices);
        searchRequest.extraSource(searchSourceBuilder);
        searchRequest.types(Strings.splitStringByCommaToArray((String)type));
        return searchRequest;
    }
}

