/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.codelibs.elasticsearch.solr.SolrPluginConstants;
import org.codelibs.elasticsearch.solr.rest.ExtendedRestRequest;
import org.codelibs.elasticsearch.solr.solr.JavaBinUpdateRequestCodec;
import org.codelibs.elasticsearch.solr.solr.SolrResponseUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public class SolrUpdateRestAction
extends BaseRestHandler {
    private static final String TRUE = "true";
    private static final String[] DEFAULT_ID_FIELDS = new String[]{"id", "docid", "documentid", "contentid", "uuid", "url"};
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final boolean hashIds;
    private final boolean commitAsFlush;
    private final boolean optimizeAsOptimize;
    private final String defaultIndexName;
    private final String defaultTypeName;
    private final String[] idFields;

    @Inject
    public SolrUpdateRestAction(Settings settings, Client client, RestController restController) {
        super(settings, restController, client);
        this.hashIds = settings.getAsBoolean("solr.hashIds", Boolean.valueOf(false));
        this.commitAsFlush = settings.getAsBoolean("solr.commitAsFlush", Boolean.valueOf(true));
        this.optimizeAsOptimize = settings.getAsBoolean("solr.optimizeAsOptimize", Boolean.valueOf(true));
        this.logger.info("Solr input document id's will " + (this.hashIds ? "" : "not ") + "be hashed to created Elasticsearch document id's", new Object[0]);
        this.defaultIndexName = settings.get("solr.default.index", "solr");
        this.defaultTypeName = settings.get("solr.default.type", "docs");
        this.idFields = settings.getAsArray("solr.idFields", DEFAULT_ID_FIELDS);
        restController.registerHandler(RestRequest.Method.GET, "/_solr/update", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/_solr/update/{handler}", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/{index}/_solr/update", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_solr/update", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/_solr/update", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/_solr/update/{handler}", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/{index}/_solr/update", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_solr/update", (RestHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(RestRequest request, final RestChannel channel, final Client client) {
        String index;
        final long startTime = System.currentTimeMillis();
        final ExtendedRestRequest requestEx = new ExtendedRestRequest(request);
        boolean isCommit = false;
        boolean isOptimize = false;
        String contentType = request.header("Content-Type");
        String requestType = null;
        if (contentType != null) {
            if (contentType.indexOf("application/javabin") >= 0) {
                requestType = "javabin";
            } else if (contentType.indexOf("application/x-www-form-urlencoded") >= 0) {
                isCommit = requestEx.paramAsBoolean("commit", false);
                isOptimize = requestEx.paramAsBoolean("optimize", false);
                requestType = "none";
            }
        }
        if (requestType == null) {
            requestType = "xml";
        }
        BulkRequest bulkRequest = Requests.bulkRequest();
        final ArrayList<DeleteByQueryRequest> deleteQueryList = new ArrayList<DeleteByQueryRequest>();
        BytesReference content = requestEx.content();
        if (content.length() == 0) {
            if (TRUE.equalsIgnoreCase(requestEx.param("commit")) || TRUE.equalsIgnoreCase(requestEx.param("softCommit")) || TRUE.equalsIgnoreCase(requestEx.param("prepareCommit")) || StringUtils.isNotBlank((String)requestEx.param("commitWithin"))) {
                isCommit = true;
            } else if (TRUE.equalsIgnoreCase(requestEx.param("optimize"))) {
                isOptimize = true;
            } else if (TRUE.equalsIgnoreCase(requestEx.param("rollback"))) {
                isCommit = true;
            }
        } else {
            if ("xml".equals(requestType)) {
                XMLStreamReader parser = null;
                try {
                    parser = this.inputFactory.createXMLStreamReader(new StringReader(content.toUtf8()));
                    boolean stop = false;
                    block23: while (!stop) {
                        int event = parser.next();
                        switch (event) {
                            case 8: {
                                stop = true;
                                break;
                            }
                            case 1: {
                                String currTag = parser.getLocalName();
                                if ("doc".equals(currTag)) {
                                    Map<String, Object> doc = this.parseXmlDoc(parser);
                                    if (doc == null) continue block23;
                                    bulkRequest.add(this.getIndexRequest(doc, requestEx));
                                    break;
                                }
                                if ("delete".equals(currTag)) {
                                    List<ActionRequest<?>> requestList = this.parseXmlDelete(parser, requestEx);
                                    for (ActionRequest<?> req : requestList) {
                                        if (req instanceof DeleteRequest) {
                                            bulkRequest.add(req);
                                            continue;
                                        }
                                        if (!(req instanceof DeleteByQueryRequest)) continue;
                                        deleteQueryList.add((DeleteByQueryRequest)req);
                                    }
                                    continue block23;
                                }
                                if ("commit".equals(currTag)) {
                                    isCommit = true;
                                    break;
                                }
                                if (!"optimize".equals(currTag)) break;
                                isOptimize = true;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error processing xml input", (Throwable)e, new Object[0]);
                    try {
                        channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Throwable)e));
                    }
                    catch (IOException e1) {
                        this.logger.error("Failed to send error response", (Throwable)e1, new Object[0]);
                    }
                    return;
                }
                finally {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (XMLStreamException e) {
                            this.logger.warn("Failed to close a parser.", (Throwable)e, new Object[0]);
                        }
                    }
                }
            }
            if ("javabin".equals(requestType)) {
                try {
                    List deleteQueries;
                    List deleteIds;
                    JavaBinUpdateRequestCodec codec = new JavaBinUpdateRequestCodec();
                    UpdateRequest req = codec.unmarshal(new ByteArrayInputStream(content.toBytes()), null);
                    List docs = req.getDocuments();
                    if (docs != null) {
                        for (SolrInputDocument doc : docs) {
                            bulkRequest.add(this.getIndexRequest(this.convertToMap(doc), requestEx));
                        }
                    }
                    if ((deleteIds = req.getDeleteById()) != null) {
                        for (String id : deleteIds) {
                            bulkRequest.add(this.getDeleteIdRequest(id, requestEx));
                        }
                    }
                    if ((deleteQueries = req.getDeleteQuery()) != null) {
                        for (String query : deleteQueries) {
                            deleteQueryList.add(this.getDeleteQueryRequest(query, requestEx));
                        }
                    }
                    isCommit = req.getAction() == AbstractUpdateRequest.ACTION.COMMIT;
                    isOptimize = req.getAction() == AbstractUpdateRequest.ACTION.OPTIMIZE;
                }
                catch (Exception e) {
                    this.logger.error("Error processing javabin input", (Throwable)e, new Object[0]);
                    try {
                        channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Throwable)e));
                    }
                    catch (IOException e1) {
                        this.logger.error("Failed to send error response", (Throwable)e1, new Object[0]);
                    }
                    return;
                }
            }
        }
        if (bulkRequest.numberOfActions() > 0) {
            client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    SolrUpdateRestAction.this.logger.info("Bulk request completed", new Object[0]);
                    StringBuilder failureBuf = null;
                    for (BulkItemResponse itemResponse : response) {
                        BulkItemResponse.Failure failure = itemResponse.getFailure();
                        if (failure == null) continue;
                        String msg = "Index request failed {index:" + failure.getIndex() + ", type:" + failure.getType() + ", id:" + failure.getId() + ", reason:" + failure.getMessage() + "}";
                        if (failureBuf == null) {
                            failureBuf = new StringBuilder();
                        }
                        failureBuf.append(msg).append('\n');
                    }
                    if (failureBuf == null) {
                        if (deleteQueryList.isEmpty()) {
                            SolrUpdateRestAction.this.sendResponse(requestEx, channel, 0, System.currentTimeMillis() - startTime, (NamedList<Object>)null);
                        } else {
                            SolrUpdateRestAction.this.deleteByQueries(client, requestEx, channel, startTime, deleteQueryList);
                        }
                    } else {
                        String failureMsg = failureBuf.toString();
                        SolrUpdateRestAction.this.logger.error(failureMsg, new Object[0]);
                        SimpleOrderedMap errorResponse = new SimpleOrderedMap();
                        errorResponse.add("code", (Object)500);
                        errorResponse.add("msg", (Object)failureMsg);
                        SolrUpdateRestAction.this.sendResponse(requestEx, channel, 500, System.currentTimeMillis() - startTime, (NamedList<Object>)((NamedList)errorResponse));
                    }
                }

                public void onFailure(Throwable e) {
                    SolrUpdateRestAction.this.logger.error("Bulk request failed", e, new Object[0]);
                    SimpleOrderedMap errorResponse = new SimpleOrderedMap();
                    errorResponse.add("code", (Object)500);
                    errorResponse.add("msg", (Object)e.getMessage());
                    SolrUpdateRestAction.this.sendResponse(requestEx, channel, 500, System.currentTimeMillis() - startTime, (NamedList<Object>)((NamedList)errorResponse));
                }
            });
        } else if (!deleteQueryList.isEmpty()) {
            this.deleteByQueries(client, requestEx, channel, startTime, deleteQueryList);
        } else if (isCommit) {
            if (this.commitAsFlush) {
                index = request.hasParam("index") ? request.param("index") : this.defaultIndexName;
                FlushRequest flushRequest = new FlushRequest(new String[]{index});
                client.admin().indices().flush(flushRequest, (ActionListener)new ActionListener<FlushResponse>(){

                    public void onResponse(FlushResponse response) {
                        SolrUpdateRestAction.this.sendResponse(requestEx, channel, 0, System.currentTimeMillis() - startTime, (NamedList<Object>)null);
                    }

                    public void onFailure(Throwable t) {
                        try {
                            channel.sendResponse((RestResponse)new BytesRestResponse(channel, t));
                        }
                        catch (IOException e) {
                            SolrUpdateRestAction.this.logger.error("Failed to send error response", (Throwable)e, new Object[0]);
                        }
                    }
                });
            } else {
                this.sendResponse(requestEx, channel, 0, System.currentTimeMillis() - startTime, null);
            }
        } else if (isOptimize) {
            if (this.optimizeAsOptimize) {
                index = request.hasParam("index") ? request.param("index") : this.defaultIndexName;
                OptimizeRequest optimizeRequest = new OptimizeRequest(new String[]{index});
                client.admin().indices().optimize(optimizeRequest, (ActionListener)new ActionListener<OptimizeResponse>(){

                    public void onResponse(OptimizeResponse response) {
                        SolrUpdateRestAction.this.sendResponse(requestEx, channel, 0, System.currentTimeMillis() - startTime, (NamedList<Object>)null);
                    }

                    public void onFailure(Throwable t) {
                        try {
                            channel.sendResponse((RestResponse)new BytesRestResponse(channel, t));
                        }
                        catch (IOException e) {
                            SolrUpdateRestAction.this.logger.error("Failed to send error response", (Throwable)e, new Object[0]);
                        }
                    }
                });
            } else {
                this.sendResponse(requestEx, channel, 0, System.currentTimeMillis() - startTime, null);
            }
        } else {
            try {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Throwable)new UnsupportedOperationException("Unsupported request: " + ((Object)((Object)requestEx)).toString())));
            }
            catch (IOException e) {
                this.logger.error("Failed to send error response", (Throwable)e, new Object[0]);
            }
        }
    }

    private void deleteByQueries(Client client, final RestRequest request, final RestChannel channel, final long startTime, List<DeleteByQueryRequest> deleteQueryList) {
        final AtomicInteger counter = new AtomicInteger(deleteQueryList.size());
        final StringBuilder failureBuf = new StringBuilder(200);
        for (DeleteByQueryRequest deleteQueryRequest : deleteQueryList) {
            client.deleteByQuery(deleteQueryRequest, (ActionListener)new ActionListener<DeleteByQueryResponse>(){

                public void onResponse(DeleteByQueryResponse response) {
                    if (counter.decrementAndGet() == 0) {
                        if (failureBuf.length() == 0) {
                            SolrUpdateRestAction.this.sendResponse(request, channel, 0, System.currentTimeMillis() - startTime, (NamedList<Object>)null);
                        } else {
                            SimpleOrderedMap errorResponse = new SimpleOrderedMap();
                            errorResponse.add("code", (Object)500);
                            errorResponse.add("msg", (Object)failureBuf.toString());
                            SolrUpdateRestAction.this.sendResponse(request, channel, 500, System.currentTimeMillis() - startTime, (NamedList<Object>)((NamedList)errorResponse));
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    SolrUpdateRestAction.this.logger.error("DeleteByQuery request failed", t, new Object[0]);
                    if (counter.decrementAndGet() == 0) {
                        failureBuf.append(t.getMessage());
                    }
                }
            });
        }
    }

    private void sendResponse(RestRequest request, RestChannel channel, int status, long qTime, NamedList<Object> errorResponse) {
        SimpleOrderedMap solrResponse = new SimpleOrderedMap();
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        responseHeader.add("status", (Object)status);
        responseHeader.add("QTime", (Object)((int)qTime));
        solrResponse.add("responseHeader", (Object)responseHeader);
        if (errorResponse != null) {
            solrResponse.add("error", errorResponse);
        }
        SolrResponseUtils.writeResponse((NamedList<Object>)solrResponse, request, channel);
    }

    private DeleteRequest getDeleteIdRequest(String id, RestRequest request) {
        String index = request.hasParam("index") ? request.param("index") : "solr";
        String type = request.hasParam("type") ? request.param("type") : "docs";
        DeleteRequest deleteRequest = new DeleteRequest(index, type, this.getId(id));
        deleteRequest.parent(request.param("parent"));
        deleteRequest.routing(request.param("routing"));
        return deleteRequest;
    }

    private DeleteByQueryRequest getDeleteQueryRequest(String query, RestRequest request) {
        String index = request.hasParam("index") ? request.param("index") : "solr";
        DeleteByQueryRequest deleteRequest = Requests.deleteByQueryRequest((String[])new String[]{index});
        deleteRequest.source("{\"query_string\":{\"query\":\"" + query + "\"}}");
        deleteRequest.routing(request.param("routing"));
        return deleteRequest;
    }

    private IndexRequest getIndexRequest(Map<String, Object> doc, RestRequest request) {
        String consistencyLevel;
        String index = request.hasParam("index") ? request.param("index") : this.defaultIndexName;
        String type = request.hasParam("type") ? request.param("type") : this.defaultTypeName;
        String id = request.hasParam("id") ? request.param("id") : this.getIdForDoc(doc);
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        indexRequest.routing(request.param("routing"));
        indexRequest.parent(request.param("parent"));
        indexRequest.source(doc);
        indexRequest.timeout(request.paramAsTime("timeout", ShardReplicationOperationRequest.DEFAULT_TIMEOUT));
        indexRequest.refresh(request.paramAsBoolean("refresh", indexRequest.refresh()));
        indexRequest.opType(IndexRequest.OpType.INDEX);
        String replicationType = request.param("replication");
        if (replicationType != null) {
            indexRequest.replicationType(ReplicationType.fromString((String)replicationType));
        }
        if ((consistencyLevel = request.param("consistency")) != null) {
            indexRequest.consistencyLevel(WriteConsistencyLevel.fromString((String)consistencyLevel));
        }
        indexRequest.listenerThreaded(true);
        indexRequest.operationThreaded(true);
        return indexRequest;
    }

    private String getIdForDoc(Map<String, Object> doc) {
        String id = null;
        for (String idField : this.idFields) {
            if (!doc.containsKey(idField)) continue;
            id = doc.get(idField).toString();
            break;
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        doc.put("id", id);
        return this.getId(id);
    }

    private final String getId(String id) {
        return this.hashIds ? this.getMD5(id) : id;
    }

    private String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = input.getBytes(SolrPluginConstants.CHARSET_UTF8);
            byte[] digest = md.digest(bytes);
            char[] encodeHex = Hex.encodeHex((byte[])digest);
            return String.valueOf(encodeHex);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ElasticsearchException("Failed to encode " + input, (Throwable)e);
        }
    }

    private Map<String, Object> convertToMap(SolrInputDocument doc) {
        HashMap<String, Object> newDoc = new HashMap<String, Object>();
        Collection fields = doc.values();
        if (fields != null) {
            for (SolrInputField field : fields) {
                newDoc.put(field.getName(), field.getValue());
            }
        }
        return newDoc;
    }

    private Map<String, Object> parseXmlDoc(XMLStreamReader parser) throws XMLStreamException {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        StringBuilder buf = new StringBuilder();
        String name = null;
        boolean stop = false;
        block5: while (!stop) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    buf.setLength(0);
                    String localName = parser.getLocalName();
                    if (!"field".equals(localName)) {
                        this.logger.warn("unexpected xml tag /doc/" + localName, new Object[0]);
                        doc = null;
                        stop = true;
                    }
                    String attrName = "";
                    String attrVal = "";
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        attrVal = parser.getAttributeValue(i);
                        if (!"name".equals(attrName)) continue;
                        name = attrVal;
                    }
                    continue block5;
                }
                case 2: {
                    if ("doc".equals(parser.getLocalName())) {
                        stop = true;
                        break;
                    }
                    if (!"field".equals(parser.getLocalName())) break;
                    if (doc.containsKey(name) && doc.get(name) instanceof List) {
                        List vals = (List)doc.get(name);
                        vals.add(buf.toString());
                        doc.put(name, vals);
                        break;
                    }
                    if (doc.containsKey(name)) {
                        ArrayList<String> vals = new ArrayList<String>();
                        vals.add((String)doc.get(name));
                        vals.add(buf.toString());
                        doc.put(name, vals);
                        break;
                    }
                    doc.put(name, buf.toString());
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    buf.append(parser.getText());
                    break;
                }
            }
        }
        return doc;
    }

    private List<ActionRequest<?>> parseXmlDelete(XMLStreamReader parser, RestRequest request) throws XMLStreamException {
        StringBuilder buf = new StringBuilder();
        boolean stop = false;
        ArrayList requestList = new ArrayList();
        while (!stop) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    buf.setLength(0);
                    break;
                }
                case 2: {
                    String currTag = parser.getLocalName();
                    if ("id".equals(currTag)) {
                        String docid = buf.toString();
                        requestList.add((ActionRequest<?>)this.getDeleteIdRequest(docid, request));
                        break;
                    }
                    if ("query".equals(currTag)) {
                        String query = buf.toString();
                        requestList.add((ActionRequest<?>)this.getDeleteQueryRequest(query, request));
                        break;
                    }
                    if ("delete".equals(currTag)) {
                        stop = true;
                        break;
                    }
                    this.logger.warn("unexpected xml tag /delete/" + currTag, new Object[0]);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    buf.append(parser.getText());
                }
            }
        }
        return requestList;
    }
}

