/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.solr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class JavaBinUpdateRequestCodec {
    public void marshal(UpdateRequest updateRequest, OutputStream os) throws IOException {
        NamedList nl = new NamedList();
        NamedList params = this.solrParamsToNamedList((SolrParams)updateRequest.getParams());
        if (updateRequest.getCommitWithin() != -1) {
            params.add("commitWithin", (Object)updateRequest.getCommitWithin());
        }
        Iterator docIter = null;
        if (updateRequest.getDocuments() != null) {
            docIter = updateRequest.getDocuments().iterator();
        }
        if (updateRequest.getDocIterator() != null) {
            docIter = updateRequest.getDocIterator();
        }
        nl.add("params", (Object)params);
        nl.add("delById", (Object)updateRequest.getDeleteById());
        nl.add("delByQ", (Object)updateRequest.getDeleteQuery());
        nl.add("docs", (Object)docIter);
        JavaBinCodec codec = new JavaBinCodec();
        codec.marshal((Object)nl, os);
    }

    public UpdateRequest unmarshal(InputStream is, final StreamingUpdateHandler handler) throws IOException {
        NamedList params;
        final UpdateRequest updateRequest = new UpdateRequest();
        final NamedList[] namedList = new NamedList[1];
        JavaBinCodec codec = new JavaBinCodec(){
            private boolean seenOuterMostDocIterator = false;

            public NamedList readNamedList(DataInputInputStream dis) throws IOException {
                int sz = this.readSize(dis);
                NamedList nl = new NamedList();
                if (namedList[0] == null) {
                    namedList[0] = nl;
                }
                for (int i = 0; i < sz; ++i) {
                    String name = (String)this.readVal(dis);
                    Object val = this.readVal(dis);
                    nl.add(name, val);
                }
                return nl;
            }

            public List readIterator(DataInputInputStream fis) throws IOException {
                if (this.seenOuterMostDocIterator) {
                    return super.readIterator(fis);
                }
                this.seenOuterMostDocIterator = true;
                return this.readOuterMostDocIterator(fis);
            }

            private List readOuterMostDocIterator(DataInputInputStream fis) throws IOException {
                Object o;
                NamedList params = (NamedList)namedList[0].getVal(0);
                updateRequest.setParams(new ModifiableSolrParams(SolrParams.toSolrParams((NamedList)params)));
                if (handler == null) {
                    return super.readIterator(fis);
                }
                while ((o = this.readVal(fis)) != END_OBJ) {
                    SolrInputDocument sdoc = null;
                    if (o instanceof List) {
                        sdoc = JavaBinUpdateRequestCodec.this.listToSolrInputDocument((List)o);
                    } else if (o instanceof NamedList) {
                        UpdateRequest req = new UpdateRequest();
                        req.setParams(new ModifiableSolrParams(SolrParams.toSolrParams((NamedList)((NamedList)o))));
                        handler.update(null, req);
                    } else {
                        sdoc = (SolrInputDocument)o;
                    }
                    handler.update(sdoc, updateRequest);
                }
                return Collections.EMPTY_LIST;
            }
        };
        codec.unmarshal(is);
        if (updateRequest.getParams() == null && (params = (NamedList)namedList[0].get("params")) != null) {
            updateRequest.setParams(new ModifiableSolrParams(SolrParams.toSolrParams((NamedList)params)));
        }
        List delById = (List)namedList[0].get("delById");
        List delByQ = (List)namedList[0].get("delByQ");
        List doclist = (List)namedList[0].get("docs");
        if (doclist != null && !doclist.isEmpty()) {
            ArrayList<SolrInputDocument> solrInputDocs = new ArrayList<SolrInputDocument>();
            for (Object o : doclist) {
                if (o instanceof List) {
                    solrInputDocs.add(this.listToSolrInputDocument((List)o));
                    continue;
                }
                solrInputDocs.add((SolrInputDocument)o);
            }
            updateRequest.add(solrInputDocs);
        }
        if (delById != null) {
            for (String s : delById) {
                updateRequest.deleteById(s);
            }
        }
        if (delByQ != null) {
            for (String s : delByQ) {
                updateRequest.deleteByQuery(s);
            }
        }
        return updateRequest;
    }

    private SolrInputDocument listToSolrInputDocument(List<NamedList> namedList) {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < namedList.size(); ++i) {
            NamedList nl = namedList.get(i);
            if (i == 0) {
                doc.setDocumentBoost(nl.getVal(0) == null ? 1.0f : ((Float)nl.getVal(0)).floatValue());
                continue;
            }
            doc.addField((String)nl.getVal(0), nl.getVal(1), nl.getVal(2) == null ? 1.0f : ((Float)nl.getVal(2)).floatValue());
        }
        return doc;
    }

    private NamedList solrParamsToNamedList(SolrParams params) {
        if (params == null) {
            return new NamedList();
        }
        return params.toNamedList();
    }

    public static interface StreamingUpdateHandler {
        public void update(SolrInputDocument var1, UpdateRequest var2);
    }
}

