/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.solr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.search.Explanation;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.codelibs.elasticsearch.solr.guava.common.io.BaseEncoding;
import org.codelibs.elasticsearch.solr.solr.XMLWriter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.highlight.HighlightField;

public class SolrResponseUtils {
    private static final ESLogger logger = Loggers.getLogger(SolrResponseUtils.class);
    private static final char[] XML_START1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".toCharArray();
    private static final char[] XML_START2_NOSCHEMA = "<response>\n".toCharArray();
    private static final String CONTENT_TYPE_OCTET = "application/octet-stream";
    private static final String CONTENT_TYPE_XML = "application/xml; charset=UTF-8";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern ISO_DATE_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?Z");
    private static final String YYYY_MM_DD_T_HH_MM_SS_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String YYYY_MM_DD_T_HH_MM_SS_SSS_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    protected SolrResponseUtils() {
    }

    private static Date parseISODateFormat(String value) {
        try {
            return new SimpleDateFormat(YYYY_MM_DD_T_HH_MM_SS_SSS_Z, Locale.ROOT).parse(value);
        }
        catch (ParseException e) {
            try {
                return new SimpleDateFormat(YYYY_MM_DD_T_HH_MM_SS_Z, Locale.ROOT).parse(value);
            }
            catch (ParseException e1) {
                throw new ElasticsearchException("Could not parse " + value, (Throwable)e);
            }
        }
    }

    public static NamedList<Object> createSearchResponse(RestRequest request, SearchResponse response) {
        NamedList<Object> faceting;
        SimpleOrderedMap resp = new SimpleOrderedMap();
        SimpleOrderedMap debugList = new SimpleOrderedMap();
        resp.add("responseHeader", SolrResponseUtils.createResponseHeader(request, response));
        resp.add("response", (Object)SolrResponseUtils.convertToSolrDocumentList(request, response, (NamedList<Object>)debugList));
        NamedList<Object> highlighting = SolrResponseUtils.createHighlightResponse(request, response);
        if (highlighting != null) {
            resp.add("highlighting", highlighting);
        }
        if ((faceting = SolrResponseUtils.createFacetResponse(request, response)) != null) {
            resp.add("facet_counts", faceting);
        }
        if (debugList.size() > 0) {
            resp.add("debug", (Object)debugList);
        }
        return resp;
    }

    public static NamedList<Object> createResponseHeader(RestRequest request, SearchResponse response) {
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        responseHeader.add("status", (Object)0);
        responseHeader.add("QTime", (Object)((int)response.getTookInMillis()));
        SimpleOrderedMap solrParams = new SimpleOrderedMap();
        for (String key : request.params().keySet()) {
            String[] values = request.paramAsStringArray(key, new String[0]);
            if (values.length <= 0) continue;
            for (String value : values) {
                solrParams.add(key, (Object)value);
            }
        }
        responseHeader.add("params", (Object)solrParams);
        return responseHeader;
    }

    public static NamedList<Object> createHighlightResponse(RestRequest request, SearchResponse response) {
        SimpleOrderedMap highlightResponse = null;
        if (request.paramAsBoolean("hl", false)) {
            highlightResponse = new SimpleOrderedMap();
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits.getHits()) {
                SimpleOrderedMap docHighlights = new SimpleOrderedMap();
                Map highlightFields = hit.getHighlightFields();
                for (Map.Entry entry : highlightFields.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    HighlightField highlightField = (HighlightField)entry.getValue();
                    Text[] fragments = highlightField.getFragments();
                    ArrayList<String> fragmentList = new ArrayList<String>(fragments.length);
                    for (Text fragment : fragments) {
                        fragmentList.add(fragment.string());
                    }
                    docHighlights.add(fieldName, (Object)fragmentList.toArray(new String[fragmentList.size()]));
                }
                highlightResponse.add(hit.id(), (Object)docHighlights);
            }
        }
        return highlightResponse;
    }

    public static NamedList<Object> createFacetResponse(RestRequest request, SearchResponse response) {
        SimpleOrderedMap facetResponse = null;
        if (request.paramAsBoolean("facet", false)) {
            facetResponse = new SimpleOrderedMap();
            SimpleOrderedMap termFacets = new SimpleOrderedMap();
            SimpleOrderedMap queryFacets = new SimpleOrderedMap();
            Iterator facetIter = response.getAggregations().iterator();
            ArrayList<Tuple> facetQueryList = null;
            while (facetIter.hasNext()) {
                Aggregation facet = (Aggregation)facetIter.next();
                if (facet.getName().startsWith("facet_field_")) {
                    Terms termFacet = (Terms)facet;
                    SimpleOrderedMap termFacetObj = new SimpleOrderedMap();
                    for (Terms.Bucket tfEntry : termFacet.getBuckets()) {
                        termFacetObj.add(tfEntry.getKeyAsText().string(), (Object)((int)tfEntry.getDocCount()));
                    }
                    String encodedField = facet.getName().substring("facet_field_".length());
                    termFacets.add(new String(BaseEncoding.base64().decode(encodedField), Charsets.UTF_8), (Object)termFacetObj);
                    continue;
                }
                if (!facet.getName().startsWith("facet_query_")) continue;
                if (facetQueryList == null) {
                    facetQueryList = new ArrayList<Tuple>();
                }
                Filter queryFacet = (Filter)facet;
                String encodedQuery = queryFacet.getName().substring("facet_query_".length());
                facetQueryList.add(new Tuple((Object)encodedQuery, (Object)((int)queryFacet.getDocCount())));
            }
            if (facetQueryList != null) {
                Collections.sort(facetQueryList, new Comparator<Tuple<String, Integer>>(){

                    @Override
                    public int compare(Tuple<String, Integer> o1, Tuple<String, Integer> o2) {
                        return ((String)o1.v1()).compareTo((String)o2.v1());
                    }
                });
                for (Tuple tuple : facetQueryList) {
                    int pos = ((String)tuple.v1()).indexOf(95);
                    queryFacets.add(new String(BaseEncoding.base64().decode(((String)tuple.v1()).substring(pos + 1)), Charsets.UTF_8), tuple.v2());
                }
            }
            facetResponse.add("facet_fields", (Object)termFacets);
            facetResponse.add("facet_queries", (Object)queryFacets);
            facetResponse.add("facet_dates", (Object)new SimpleOrderedMap());
            facetResponse.add("facet_ranges", (Object)new SimpleOrderedMap());
        }
        return facetResponse;
    }

    public static SolrDocumentList convertToSolrDocumentList(RestRequest request, SearchResponse response, NamedList<Object> debugList) {
        SimpleOrderedMap explainList = null;
        SolrDocumentList results = new SolrDocumentList();
        SearchHits hits = response.getHits();
        results.setMaxScore(Float.valueOf(hits.getMaxScore()));
        results.setNumFound(hits.getTotalHits());
        results.setStart((long)request.paramAsInt("start", 0));
        for (SearchHit hit : hits.getHits()) {
            Explanation explanation;
            SolrDocument doc = new SolrDocument();
            doc.addField("score", (Object)Float.valueOf(hit.score()));
            Map fields = hit.getFields();
            Map source = hit.sourceAsMap();
            if (fields.isEmpty()) {
                if (source != null) {
                    for (Map.Entry entry : source.entrySet()) {
                        String sourceField = (String)entry.getKey();
                        Object fieldValue = entry.getValue();
                        if (fieldValue instanceof String && ISO_DATE_PATTERN.matcher(fieldValue.toString()).matches()) {
                            fieldValue = SolrResponseUtils.parseISODateFormat(fieldValue.toString());
                        }
                        doc.addField(sourceField, fieldValue);
                    }
                }
            } else {
                for (Map.Entry entry : fields.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    SearchHitField field = (SearchHitField)entry.getValue();
                    Object fieldValue = field.getValue();
                    if (fieldValue instanceof String && ISO_DATE_PATTERN.matcher(fieldValue.toString()).matches()) {
                        fieldValue = SolrResponseUtils.parseISODateFormat(fieldValue.toString());
                    }
                    doc.addField(fieldName, fieldValue);
                }
            }
            if ((explanation = hit.getExplanation()) != null) {
                if (explainList == null) {
                    explainList = new SimpleOrderedMap();
                }
                explainList.add(hit.getId(), (Object)explanation.toString());
            }
            results.add((Object)doc);
        }
        if (explainList != null) {
            debugList.add("explain", explainList);
        }
        return results;
    }

    public static void writeResponse(NamedList<Object> obj, RestRequest request, RestChannel channel) {
        String wt;
        String string = wt = request.hasParam("wt") ? request.param("wt").toLowerCase() : "xml";
        if (wt.equals("xml")) {
            SolrResponseUtils.writeXmlResponse(obj, channel);
        } else if (wt.equals("javabin")) {
            SolrResponseUtils.writeJavaBinResponse(obj, channel);
        } else {
            SolrResponseUtils.writeXmlResponse(obj, channel);
        }
    }

    private static void writeJavaBinResponse(NamedList<Object> obj, RestChannel channel) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            new JavaBinCodec().marshal(obj, (OutputStream)bo);
        }
        catch (IOException e) {
            logger.error("Error writing JavaBin response", (Throwable)e, new Object[0]);
        }
        Object errorResponse = obj.get("error");
        channel.sendResponse((RestResponse)new BytesRestResponse(errorResponse != null ? RestStatus.INTERNAL_SERVER_ERROR : RestStatus.OK, CONTENT_TYPE_OCTET, bo.toByteArray()));
    }

    private static void writeXmlResponse(NamedList<Object> obj, RestChannel channel) {
        StringWriter writer = new StringWriter();
        try {
            writer.write(XML_START1);
            writer.write(XML_START2_NOSCHEMA);
            XMLWriter xw = new XMLWriter(writer);
            int sz = obj.size();
            for (int i = 0; i < sz; ++i) {
                xw.writeVal(obj.getName(i), obj.getVal(i));
            }
            ((Writer)writer).write("\n</response>\n");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            logger.error("Error writing XML response", (Throwable)e, new Object[0]);
        }
        Object errorResponse = obj.get("error");
        channel.sendResponse((RestResponse)new BytesRestResponse(errorResponse != null ? RestStatus.INTERNAL_SERVER_ERROR : RestStatus.OK, CONTENT_TYPE_XML, ((Object)writer).toString().getBytes(UTF_8)));
    }
}

