/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.solr.solr;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.format.DateTimeFormat;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;

public final class XMLWriter {
    private final Writer writer;
    private final DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeAttr(String name, String val) throws IOException {
        this.writeAttr(name, val, true);
    }

    public void writeAttr(String name, String val, boolean escape) throws IOException {
        if (val != null) {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            if (escape) {
                XML.escapeAttributeValue((String)val, (Writer)this.writer);
            } else {
                this.writer.write(val);
            }
            this.writer.write(34);
        }
    }

    public void startTag(String tag, Map<String, String> attributes, boolean closeTag, boolean escape) throws IOException {
        this.writer.write(60);
        this.writer.write(tag);
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writeAttr(entry.getKey(), entry.getValue(), escape);
            }
        }
        if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write(62);
        }
    }

    public void writeCdataTag(String tag, Map<String, String> attributes, String cdata, boolean escapeCdata, boolean escapeAttr) throws IOException {
        this.writer.write(60);
        this.writer.write(tag);
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writeAttr(entry.getKey(), entry.getValue(), escapeAttr);
            }
        }
        this.writer.write(62);
        if (cdata != null && cdata.length() > 0) {
            if (escapeCdata) {
                XML.escapeCharData((String)cdata, (Writer)this.writer);
            } else {
                this.writer.write(cdata, 0, cdata.length());
            }
        }
        this.writer.write("</");
        this.writer.write(tag);
        this.writer.write(62);
    }

    public void startTag(String tag, String name, boolean closeTag) throws IOException {
        this.writer.write(60);
        this.writer.write(tag);
        if (name != null) {
            this.writeAttr("name", name);
            if (closeTag) {
                this.writer.write("/>");
            } else {
                this.writer.write(">");
            }
        } else if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write(62);
        }
    }

    final void writeDoc(String name, SolrDocument doc, Set<String> returnFields, boolean includeScore) throws IOException {
        this.startTag("doc", name, false);
        if (includeScore && returnFields != null) {
            returnFields.add("score");
        }
        for (String fname : doc.getFieldNames()) {
            if (returnFields != null && !returnFields.contains(fname)) continue;
            Object val = doc.getFieldValue(fname);
            this.writeVal(fname, val);
        }
        this.writer.write("</doc>");
    }

    private final void writeDocuments(String name, DocumentListInfo docs, Set<String> fields) throws IOException {
        boolean includeScore = false;
        Set<String> value = fields;
        if (fields != null) {
            includeScore = fields.contains("score");
            if (fields.size() == 0 || fields.size() == 1 && includeScore || fields.contains("*")) {
                value = null;
            }
        }
        int sz = docs.getCount();
        this.writer.write("<result");
        this.writeAttr("name", name);
        this.writeAttr("numFound", Long.toString(docs.getNumFound()));
        this.writeAttr("start", Long.toString(docs.getStart()));
        if (includeScore && docs.getMaxScore() != null) {
            this.writeAttr("maxScore", Float.toString(docs.getMaxScore().floatValue()));
        }
        if (sz == 0) {
            this.writer.write("/>");
            return;
        }
        this.writer.write(62);
        docs.writeDocs(includeScore, value);
        this.writer.write("</result>");
    }

    public final void writeSolrDocumentList(String name, final SolrDocumentList docs, Set<String> fields) throws IOException {
        this.writeDocuments(name, new DocumentListInfo(){

            @Override
            public int getCount() {
                return docs.size();
            }

            @Override
            public Float getMaxScore() {
                return docs.getMaxScore();
            }

            @Override
            public long getNumFound() {
                return docs.getNumFound();
            }

            @Override
            public long getStart() {
                return docs.getStart();
            }

            @Override
            public void writeDocs(boolean includeScore, Set<String> fields) throws IOException {
                for (SolrDocument doc : docs) {
                    XMLWriter.this.writeDoc(null, doc, fields, includeScore);
                }
            }
        }, fields);
    }

    public void writeVal(String name, Object val) throws IOException {
        if (val == null) {
            this.writeNull(name);
        } else if (val instanceof String) {
            this.writeStr(name, (String)val);
        } else if (val instanceof Integer) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Boolean) {
            this.writeBool(name, val.toString());
        } else if (val instanceof Long) {
            this.writeLong(name, val.toString());
        } else if (val instanceof Date) {
            this.writeDate(name, (Date)val);
        } else if (val instanceof Float) {
            this.writeFloat(name, ((Float)val).floatValue());
        } else if (val instanceof Double) {
            this.writeDouble(name, (Double)val);
        } else if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList(name, (SolrDocumentList)val, null);
        } else if (val instanceof Map) {
            this.writeMap(name, (Map)val);
        } else if (val instanceof NamedList) {
            this.writeNamedList(name, (NamedList)val);
        } else if (val instanceof Iterable) {
            this.writeArray(name, ((Iterable)val).iterator());
        } else if (val instanceof Object[]) {
            this.writeArray(name, (Object[])val);
        } else if (val instanceof Iterator) {
            this.writeArray(name, (Iterator)val);
        } else {
            this.writeStr(name, val.getClass().getName() + ':' + val.toString());
        }
    }

    public void writeNamedList(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.startTag("lst", name, sz <= 0);
        for (int i = 0; i < sz; ++i) {
            this.writeVal(val.getName(i), val.getVal(i));
        }
        if (sz > 0) {
            this.writer.write("</lst>");
        }
    }

    public void writeMap(String name, Map<Object, Object> map) throws IOException {
        int sz = map.size();
        this.startTag("lst", name, sz <= 0);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeVal(null == k ? null : k.toString(), v);
        }
        if (sz > 0) {
            this.writer.write("</lst>");
        }
    }

    public void writeArray(String name, Object[] val) throws IOException {
        this.writeArray(name, Arrays.asList(val).iterator());
    }

    public void writeArray(String name, Iterator iter) throws IOException {
        if (iter.hasNext()) {
            this.startTag("arr", name, false);
            while (iter.hasNext()) {
                this.writeVal(null, iter.next());
            }
            this.writer.write("</arr>");
        } else {
            this.startTag("arr", name, true);
        }
    }

    public void writeNull(String name) throws IOException {
        this.writePrim("null", name, "", false);
    }

    public void writeStr(String name, String val) throws IOException {
        this.writePrim("str", name, val, true);
    }

    public void writeInt(String name, String val) throws IOException {
        this.writePrim("int", name, val, false);
    }

    public void writeInt(String name, int val) throws IOException {
        this.writeInt(name, Integer.toString(val));
    }

    public void writeLong(String name, String val) throws IOException {
        this.writePrim("long", name, val, false);
    }

    public void writeLong(String name, long val) throws IOException {
        this.writeLong(name, Long.toString(val));
    }

    public void writeBool(String name, String val) throws IOException {
        this.writePrim("bool", name, val, false);
    }

    public void writeBool(String name, boolean val) throws IOException {
        this.writeBool(name, Boolean.toString(val));
    }

    public void writeShort(String name, String val) throws IOException {
        this.writePrim("short", name, val, false);
    }

    public void writeShort(String name, short val) throws IOException {
        this.writeInt(name, Short.toString(val));
    }

    public void writeByte(String name, String val) throws IOException {
        this.writePrim("byte", name, val, false);
    }

    public void writeByte(String name, byte val) throws IOException {
        this.writeInt(name, Byte.toString(val));
    }

    public void writeFloat(String name, String val) throws IOException {
        this.writePrim("float", name, val, false);
    }

    public void writeFloat(String name, float val) throws IOException {
        this.writeFloat(name, Float.toString(val));
    }

    public void writeDouble(String name, String val) throws IOException {
        this.writePrim("double", name, val, false);
    }

    public void writeDouble(String name, double val) throws IOException {
        this.writeDouble(name, Double.toString(val));
    }

    public void writeDate(String name, Date val) throws IOException {
        this.writeDate(name, new DateTime((Object)val).toString(this.dateFormat));
    }

    public void writeDate(String name, String val) throws IOException {
        this.writePrim("date", name, val, false);
    }

    public void writePrim(String tag, String name, String val, boolean escape) throws IOException {
        int contentLen = val.length();
        this.startTag(tag, name, contentLen == 0);
        if (contentLen == 0) {
            return;
        }
        if (escape) {
            XML.escapeCharData((String)val, (Writer)this.writer);
        } else {
            this.writer.write(val, 0, contentLen);
        }
        this.writer.write("</");
        this.writer.write(tag);
        this.writer.write(62);
    }

    private static interface DocumentListInfo {
        public Float getMaxScore();

        public int getCount();

        public long getNumFound();

        public long getStart();

        public void writeDocs(boolean var1, Set<String> var2) throws IOException;
    }
}

