/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.util.netty;

import java.lang.reflect.Field;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.rest.RestChannel;

public final class NettyUtils {
    private static final String CHANNEL_FIELD_NAME = "channel";
    private static final ESLogger logger = Loggers.getLogger(NettyUtils.class);
    private static Field channelField;

    private NettyUtils() {
    }

    public static Channel getChannel(RestChannel channel) {
        try {
            if (channelField == null) {
                channelField = channel.getClass().getDeclaredField(CHANNEL_FIELD_NAME);
                channelField.setAccessible(true);
            }
            return (Channel)channelField.get(channel);
        }
        catch (Exception e) {
            logger.error("Could not load Netty's channel.", (Throwable)e, new Object[0]);
            return null;
        }
    }
}

