/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.painless.Augmentation;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.DefBootstrap;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Executable;
import org.elasticsearch.painless.NeedsScore;
import org.elasticsearch.painless.PainlessError;
import org.elasticsearch.painless.Utility;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class WriterConstants {
    public static final int CLASS_VERSION = 52;
    public static final int ASM_VERSION = 327680;
    public static final String BASE_CLASS_NAME;
    public static final Type BASE_CLASS_TYPE;
    public static final String CLASS_NAME;
    public static final Type CLASS_TYPE;
    public static final Method CONSTRUCTOR;
    public static final Method CLINIT;
    public static final Method EXECUTE;
    public static final Type PAINLESS_ERROR_TYPE;
    public static final Type NEEDS_SCORE_TYPE;
    public static final Type SCORER_TYPE;
    public static final Method SCORER_SCORE;
    public static final Type MAP_TYPE;
    public static final Method MAP_GET;
    public static final Type ITERATOR_TYPE;
    public static final Method ITERATOR_HASNEXT;
    public static final Method ITERATOR_NEXT;
    public static final Type UTILITY_TYPE;
    public static final Method STRING_TO_CHAR;
    public static final Method CHAR_TO_STRING;
    public static final Type METHOD_HANDLE_TYPE;
    public static final Type AUGMENTATION_TYPE;
    public static final Method PATTERN_COMPILE;
    public static final Method PATTERN_MATCHER;
    public static final Method MATCHER_MATCHES;
    public static final Method MATCHER_FIND;
    static final MethodType DEF_BOOTSTRAP_TYPE;
    static final Handle DEF_BOOTSTRAP_HANDLE;
    public static final Type DEF_UTIL_TYPE;
    public static final Method DEF_TO_BOOLEAN;
    public static final Method DEF_TO_BYTE_IMPLICIT;
    public static final Method DEF_TO_SHORT_IMPLICIT;
    public static final Method DEF_TO_CHAR_IMPLICIT;
    public static final Method DEF_TO_INT_IMPLICIT;
    public static final Method DEF_TO_LONG_IMPLICIT;
    public static final Method DEF_TO_FLOAT_IMPLICIT;
    public static final Method DEF_TO_DOUBLE_IMPLICIT;
    public static final Method DEF_TO_BYTE_EXPLICIT;
    public static final Method DEF_TO_SHORT_EXPLICIT;
    public static final Method DEF_TO_CHAR_EXPLICIT;
    public static final Method DEF_TO_INT_EXPLICIT;
    public static final Method DEF_TO_LONG_EXPLICIT;
    public static final Method DEF_TO_FLOAT_EXPLICIT;
    public static final Method DEF_TO_DOUBLE_EXPLICIT;
    public static final Type DEF_ARRAY_LENGTH_METHOD_TYPE;
    public static final MethodType LAMBDA_BOOTSTRAP_TYPE;
    public static final Handle LAMBDA_BOOTSTRAP_HANDLE;
    public static final Handle INDY_STRING_CONCAT_BOOTSTRAP_HANDLE;
    public static final int MAX_INDY_STRING_CONCAT_ARGS = 200;
    public static final Type STRING_TYPE;
    public static final Type STRINGBUILDER_TYPE;
    public static final Method STRINGBUILDER_CONSTRUCTOR;
    public static final Method STRINGBUILDER_APPEND_BOOLEAN;
    public static final Method STRINGBUILDER_APPEND_CHAR;
    public static final Method STRINGBUILDER_APPEND_INT;
    public static final Method STRINGBUILDER_APPEND_LONG;
    public static final Method STRINGBUILDER_APPEND_FLOAT;
    public static final Method STRINGBUILDER_APPEND_DOUBLE;
    public static final Method STRINGBUILDER_APPEND_STRING;
    public static final Method STRINGBUILDER_APPEND_OBJECT;
    public static final Method STRINGBUILDER_TOSTRING;
    public static final Type OBJECTS_TYPE;
    public static final Method EQUALS;
    public static final Type COLLECTION_TYPE;
    public static final Method COLLECTION_SIZE;

    private static Method getAsmMethod(Class<?> rtype, String name, Class<?> ... ptypes) {
        return new Method(name, MethodType.methodType(rtype, ptypes).toMethodDescriptorString());
    }

    private WriterConstants() {
    }

    static {
        Handle bs;
        BASE_CLASS_NAME = Executable.class.getName();
        BASE_CLASS_TYPE = Type.getType(Executable.class);
        CLASS_NAME = BASE_CLASS_NAME + "$Script";
        CLASS_TYPE = Type.getObjectType((String)CLASS_NAME.replace('.', '/'));
        CONSTRUCTOR = WriterConstants.getAsmMethod(Void.TYPE, "<init>", String.class, String.class, BitSet.class);
        CLINIT = WriterConstants.getAsmMethod(Void.TYPE, "<clinit>", new Class[0]);
        EXECUTE = WriterConstants.getAsmMethod(Object.class, "execute", Map.class, Scorer.class, LeafDocLookup.class, Object.class);
        PAINLESS_ERROR_TYPE = Type.getType(PainlessError.class);
        NEEDS_SCORE_TYPE = Type.getType(NeedsScore.class);
        SCORER_TYPE = Type.getType(Scorer.class);
        SCORER_SCORE = WriterConstants.getAsmMethod(Float.TYPE, "score", new Class[0]);
        MAP_TYPE = Type.getType(Map.class);
        MAP_GET = WriterConstants.getAsmMethod(Object.class, "get", Object.class);
        ITERATOR_TYPE = Type.getType(Iterator.class);
        ITERATOR_HASNEXT = WriterConstants.getAsmMethod(Boolean.TYPE, "hasNext", new Class[0]);
        ITERATOR_NEXT = WriterConstants.getAsmMethod(Object.class, "next", new Class[0]);
        UTILITY_TYPE = Type.getType(Utility.class);
        STRING_TO_CHAR = WriterConstants.getAsmMethod(Character.TYPE, "StringTochar", String.class);
        CHAR_TO_STRING = WriterConstants.getAsmMethod(String.class, "charToString", Character.TYPE);
        METHOD_HANDLE_TYPE = Type.getType(MethodHandle.class);
        AUGMENTATION_TYPE = Type.getType(Augmentation.class);
        PATTERN_COMPILE = WriterConstants.getAsmMethod(Pattern.class, "compile", String.class, Integer.TYPE);
        PATTERN_MATCHER = WriterConstants.getAsmMethod(Matcher.class, "matcher", CharSequence.class);
        MATCHER_MATCHES = WriterConstants.getAsmMethod(Boolean.TYPE, "matches", new Class[0]);
        MATCHER_FIND = WriterConstants.getAsmMethod(Boolean.TYPE, "find", new Class[0]);
        DEF_BOOTSTRAP_TYPE = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class);
        DEF_BOOTSTRAP_HANDLE = new Handle(6, Type.getInternalName(DefBootstrap.class), "bootstrap", DEF_BOOTSTRAP_TYPE.toMethodDescriptorString(), false);
        DEF_UTIL_TYPE = Type.getType(Def.class);
        DEF_TO_BOOLEAN = WriterConstants.getAsmMethod(Boolean.TYPE, "DefToboolean", Object.class);
        DEF_TO_BYTE_IMPLICIT = WriterConstants.getAsmMethod(Byte.TYPE, "DefTobyteImplicit", Object.class);
        DEF_TO_SHORT_IMPLICIT = WriterConstants.getAsmMethod(Short.TYPE, "DefToshortImplicit", Object.class);
        DEF_TO_CHAR_IMPLICIT = WriterConstants.getAsmMethod(Character.TYPE, "DefTocharImplicit", Object.class);
        DEF_TO_INT_IMPLICIT = WriterConstants.getAsmMethod(Integer.TYPE, "DefTointImplicit", Object.class);
        DEF_TO_LONG_IMPLICIT = WriterConstants.getAsmMethod(Long.TYPE, "DefTolongImplicit", Object.class);
        DEF_TO_FLOAT_IMPLICIT = WriterConstants.getAsmMethod(Float.TYPE, "DefTofloatImplicit", Object.class);
        DEF_TO_DOUBLE_IMPLICIT = WriterConstants.getAsmMethod(Double.TYPE, "DefTodoubleImplicit", Object.class);
        DEF_TO_BYTE_EXPLICIT = WriterConstants.getAsmMethod(Byte.TYPE, "DefTobyteExplicit", Object.class);
        DEF_TO_SHORT_EXPLICIT = WriterConstants.getAsmMethod(Short.TYPE, "DefToshortExplicit", Object.class);
        DEF_TO_CHAR_EXPLICIT = WriterConstants.getAsmMethod(Character.TYPE, "DefTocharExplicit", Object.class);
        DEF_TO_INT_EXPLICIT = WriterConstants.getAsmMethod(Integer.TYPE, "DefTointExplicit", Object.class);
        DEF_TO_LONG_EXPLICIT = WriterConstants.getAsmMethod(Long.TYPE, "DefTolongExplicit", Object.class);
        DEF_TO_FLOAT_EXPLICIT = WriterConstants.getAsmMethod(Float.TYPE, "DefTofloatExplicit", Object.class);
        DEF_TO_DOUBLE_EXPLICIT = WriterConstants.getAsmMethod(Double.TYPE, "DefTodoubleExplicit", Object.class);
        DEF_ARRAY_LENGTH_METHOD_TYPE = Type.getMethodType((Type)Type.INT_TYPE, (Type[])new Type[]{Definition.DEF_TYPE.type});
        LAMBDA_BOOTSTRAP_TYPE = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
        LAMBDA_BOOTSTRAP_HANDLE = new Handle(6, Type.getInternalName(LambdaMetafactory.class), "altMetafactory", LAMBDA_BOOTSTRAP_TYPE.toMethodDescriptorString(), false);
        try {
            Class<?> factory = Class.forName("java.lang.invoke.StringConcatFactory");
            String methodName = "makeConcat";
            MethodType type = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
            MethodHandles.publicLookup().findStatic(factory, "makeConcat", type);
            bs = new Handle(6, Type.getInternalName(factory), "makeConcat", type.toMethodDescriptorString(), false);
        }
        catch (ReflectiveOperationException e) {
            bs = null;
        }
        INDY_STRING_CONCAT_BOOTSTRAP_HANDLE = bs;
        STRING_TYPE = Type.getType(String.class);
        STRINGBUILDER_TYPE = Type.getType(StringBuilder.class);
        STRINGBUILDER_CONSTRUCTOR = WriterConstants.getAsmMethod(Void.TYPE, "<init>", new Class[0]);
        STRINGBUILDER_APPEND_BOOLEAN = WriterConstants.getAsmMethod(StringBuilder.class, "append", Boolean.TYPE);
        STRINGBUILDER_APPEND_CHAR = WriterConstants.getAsmMethod(StringBuilder.class, "append", Character.TYPE);
        STRINGBUILDER_APPEND_INT = WriterConstants.getAsmMethod(StringBuilder.class, "append", Integer.TYPE);
        STRINGBUILDER_APPEND_LONG = WriterConstants.getAsmMethod(StringBuilder.class, "append", Long.TYPE);
        STRINGBUILDER_APPEND_FLOAT = WriterConstants.getAsmMethod(StringBuilder.class, "append", Float.TYPE);
        STRINGBUILDER_APPEND_DOUBLE = WriterConstants.getAsmMethod(StringBuilder.class, "append", Double.TYPE);
        STRINGBUILDER_APPEND_STRING = WriterConstants.getAsmMethod(StringBuilder.class, "append", String.class);
        STRINGBUILDER_APPEND_OBJECT = WriterConstants.getAsmMethod(StringBuilder.class, "append", Object.class);
        STRINGBUILDER_TOSTRING = WriterConstants.getAsmMethod(String.class, "toString", new Class[0]);
        OBJECTS_TYPE = Type.getType(Objects.class);
        EQUALS = WriterConstants.getAsmMethod(Boolean.TYPE, "equals", Object.class, Object.class);
        COLLECTION_TYPE = Type.getType(Collection.class);
        COLLECTION_SIZE = WriterConstants.getAsmMethod(Integer.TYPE, "size", new Class[0]);
    }
}

