/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client;

import java.util.Map;

public class EngineInfo {
    private static final String UNKNOWN = "unknown";
    private final String nodeName;
    private final String clusterName;
    private final String number;
    private final String distribution;

    public EngineInfo(Map<String, Object> content) {
        this.nodeName = (String)content.getOrDefault("name", UNKNOWN);
        this.clusterName = (String)content.getOrDefault("cluster_name", UNKNOWN);
        Map versionObj = (Map)content.get("version");
        if (versionObj != null) {
            this.number = versionObj.getOrDefault("number", UNKNOWN);
            this.distribution = versionObj.getOrDefault("distribution", "elasticsearch");
        } else {
            this.number = UNKNOWN;
            this.distribution = UNKNOWN;
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public EngineType getType() {
        if (this.distribution.startsWith("elasticsearch")) {
            if (this.number.startsWith("7.")) {
                return EngineType.ELASTICSEARCH7;
            }
            if (this.number.startsWith("8.")) {
                return EngineType.ELASTICSEARCH8;
            }
        } else if (this.distribution.startsWith("opensearch")) {
            if (this.number.startsWith("1.")) {
                return EngineType.OPENSEARCH1;
            }
            if (this.number.startsWith("2.")) {
                return EngineType.OPENSEARCH2;
            }
        }
        return EngineType.UNKNOWN;
    }

    public static enum EngineType {
        ELASTICSEARCH7,
        ELASTICSEARCH8,
        OPENSEARCH1,
        OPENSEARCH2,
        UNKNOWN;

    }
}

