/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class HttpAnalyzeAction
extends HttpAction {
    protected final AnalyzeAction action;
    private static final ConstructingObjectParser<AnalyzeAction.AnalyzeTokenList, Void> ATL_PARSER = new ConstructingObjectParser("token_list", true, args -> new AnalyzeAction.AnalyzeTokenList((String)args[0], HttpAnalyzeAction.fromList(AnalyzeAction.AnalyzeToken.class, (List)args[1])));
    private static final ConstructingObjectParser<AnalyzeAction.CharFilteredText, Void> CFT_PARSER;
    static final ConstructingObjectParser<AnalyzeAction.DetailAnalyzeResponse, Void> DETAIL_PARSER;
    private static final ConstructingObjectParser<AnalyzeAction.Response, Void> PARSER;

    public HttpAnalyzeAction(HttpClient client, AnalyzeAction action) {
        super(client);
        this.action = action;
    }

    public void execute(AnalyzeAction.Request request, ActionListener<AnalyzeAction.Response> listener) {
        String source = null;
        try (XContentBuilder builder = this.toXContent(request, JsonXContent.contentBuilder());){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                AnalyzeAction.Response cancelTasksResponse = HttpAnalyzeAction.fromXContent(parser);
                listener.onResponse((Object)cancelTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(AnalyzeAction.Request request) {
        return this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_analyze", request.index() == null ? new String[]{} : request.indices());
    }

    protected XContentBuilder toXContent(AnalyzeAction.Request request, XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.field("text", (Object)request.text());
        if (!Strings.isNullOrEmpty((String)request.analyzer())) {
            builder.field("analyzer", request.analyzer());
        }
        if (request.tokenizer() != null) {
            builder.field("tokenizer", (ToXContent)request.tokenizer());
        }
        if (request.tokenFilters().size() > 0) {
            builder.field("filter", (Iterable)request.tokenFilters());
        }
        if (request.charFilters().size() > 0) {
            builder.field("char_filter", (Iterable)request.charFilters());
        }
        if (!Strings.isNullOrEmpty((String)request.field())) {
            builder.field("field", request.field());
        }
        if (request.explain()) {
            builder.field("explain", true);
        }
        if (request.attributes().length > 0) {
            builder.field("attributes", (Object)request.attributes());
        }
        if (!Strings.isNullOrEmpty((String)request.normalizer())) {
            builder.field("normalizer", request.normalizer());
        }
        return builder.endObject();
    }

    private static <T> T[] fromList(Class<T> clazz, List<T> list) {
        if (list == null) {
            return null;
        }
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static AnalyzeAction.Response fromXContent(XContentParser parser) throws IOException {
        return (AnalyzeAction.Response)PARSER.parse(parser, null);
    }

    protected static AnalyzeAction.AnalyzeToken getAnalyzeTokenFromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String field = null;
        String term = "";
        int position = -1;
        int startOffset = -1;
        int endOffset = -1;
        int positionLength = 1;
        String type = "";
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        XContentParser.Token t = parser.nextToken();
        while (t != XContentParser.Token.END_OBJECT) {
            if (t == XContentParser.Token.FIELD_NAME) {
                field = parser.currentName();
            } else if ("token".equals(field)) {
                term = parser.text();
            } else if ("position".equals(field)) {
                position = parser.intValue();
            } else if ("start_offset".equals(field)) {
                startOffset = parser.intValue();
            } else if ("end_offset".equals(field)) {
                endOffset = parser.intValue();
            } else if ("positionLength".equals(field)) {
                positionLength = parser.intValue();
            } else if ("type".equals(field)) {
                type = parser.text();
            } else if (t == XContentParser.Token.VALUE_STRING) {
                attributes.put(field, parser.text());
            } else if (t == XContentParser.Token.VALUE_NUMBER) {
                attributes.put(field, parser.numberValue());
            } else if (t == XContentParser.Token.VALUE_BOOLEAN) {
                attributes.put(field, parser.booleanValue());
            } else if (t == XContentParser.Token.START_OBJECT) {
                attributes.put(field, parser.map());
            } else if (t == XContentParser.Token.START_ARRAY) {
                attributes.put(field, parser.list());
            }
            t = parser.nextToken();
        }
        return new AnalyzeAction.AnalyzeToken(term, position, startOffset, endOffset, positionLength, type, attributes);
    }

    private static AnalyzeAction.DetailAnalyzeResponse createDetailAnalyzeResponse(boolean customAnalyzer, AnalyzeAction.AnalyzeTokenList analyzer, AnalyzeAction.CharFilteredText[] charfilters, AnalyzeAction.AnalyzeTokenList tokenizer, AnalyzeAction.AnalyzeTokenList[] tokenfilters) {
        if (customAnalyzer) {
            return new AnalyzeAction.DetailAnalyzeResponse(charfilters, tokenizer, tokenfilters);
        }
        return new AnalyzeAction.DetailAnalyzeResponse(analyzer);
    }

    static {
        ATL_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        ATL_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> HttpAnalyzeAction.getAnalyzeTokenFromXContent(p), new ParseField("tokens", new String[0]));
        CFT_PARSER = new ConstructingObjectParser("char_filtered_text", true, args -> new AnalyzeAction.CharFilteredText((String)args[0], ((List)args[1]).toArray(new String[0])));
        CFT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        CFT_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("filtered_text", new String[0]));
        DETAIL_PARSER = new ConstructingObjectParser("detail", true, args -> HttpAnalyzeAction.createDetailAnalyzeResponse((Boolean)args[0], (AnalyzeAction.AnalyzeTokenList)args[1], HttpAnalyzeAction.fromList(AnalyzeAction.CharFilteredText.class, (List)args[2]), (AnalyzeAction.AnalyzeTokenList)args[3], HttpAnalyzeAction.fromList(AnalyzeAction.AnalyzeTokenList.class, (List)args[4])));
        DETAIL_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("custom_analyzer", new String[0]));
        DETAIL_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ATL_PARSER, new ParseField("analyzer", new String[0]));
        DETAIL_PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), CFT_PARSER, new ParseField("charfilters", new String[0]));
        DETAIL_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ATL_PARSER, new ParseField("tokenizer", new String[0]));
        DETAIL_PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), ATL_PARSER, new ParseField("tokenfilters", new String[0]));
        PARSER = new ConstructingObjectParser("analyze_response", true, args -> new AnalyzeAction.Response((List)args[0], (AnalyzeAction.DetailAnalyzeResponse)args[1]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> HttpAnalyzeAction.getAnalyzeTokenFromXContent(p), new ParseField("tokens", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DETAIL_PARSER, new ParseField("detail", new String[0]));
    }

    static final class Fields {
        static final String TOKENS = "tokens";
        static final String TOKEN = "token";
        static final String START_OFFSET = "start_offset";
        static final String END_OFFSET = "end_offset";
        static final String TYPE = "type";
        static final String POSITION = "position";
        static final String POSITION_LENGTH = "positionLength";
        static final String DETAIL = "detail";
        static final String NAME = "name";
        static final String FILTERED_TEXT = "filtered_text";
        static final String CUSTOM_ANALYZER = "custom_analyzer";
        static final String ANALYZER = "analyzer";
        static final String CHARFILTERS = "charfilters";
        static final String TOKENIZER = "tokenizer";
        static final String TOKENFILTERS = "tokenfilters";

        Fields() {
        }
    }
}

