/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.close.CloseIndexAction;
import org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.opensearch.action.admin.indices.close.CloseIndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.XContentParser;

public class HttpCloseIndexAction
extends HttpAction {
    protected final CloseIndexAction action;

    public HttpCloseIndexAction(HttpClient client, CloseIndexAction action) {
        super(client);
        this.action = action;
    }

    public void execute(CloseIndexRequest request, ActionListener<CloseIndexResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                CloseIndexResponse closeIndexResponse = this.fromXContent(parser);
                listener.onResponse((Object)closeIndexResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(CloseIndexRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_close", request.indices());
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }

    protected CloseIndexResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        List<Object> indices = Collections.emptyList();
        boolean shardsAcknowledged = false;
        boolean acknowledged = false;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("indices".equals(fieldName)) {
                    parser.nextToken();
                    indices = this.parseIndices(parser);
                }
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("shards_acknowledged".equals(fieldName)) {
                    shardsAcknowledged = parser.booleanValue();
                } else if ("acknowledged".equals(fieldName)) {
                    acknowledged = parser.booleanValue();
                }
            }
            parser.nextToken();
        }
        return new CloseIndexResponse(acknowledged, shardsAcknowledged, indices);
    }

    protected List<CloseIndexResponse.IndexResult> parseIndices(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<CloseIndexResponse.IndexResult> list = new ArrayList<CloseIndexResponse.IndexResult>();
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                list.add(this.parseIndexResult(parser, fieldName));
            }
            parser.nextToken();
        }
        return list;
    }

    protected CloseIndexResponse.IndexResult parseIndexResult(XContentParser parser, String index) throws IOException {
        XContentParser.Token token;
        boolean closed = false;
        OpenSearchException eex = null;
        ArrayList<CloseIndexResponse.ShardResult> shardResults = new ArrayList<CloseIndexResponse.ShardResult>();
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("exception".equals(fieldName)) {
                    parser.nextToken();
                    eex = OpenSearchException.fromXContent((XContentParser)parser);
                } else if ("failedShards".equals(fieldName)) {
                    parser.nextToken();
                    shardResults.addAll(this.parseShardResults(parser));
                }
            } else if (token == XContentParser.Token.VALUE_BOOLEAN && "closed".equals(fieldName)) {
                closed = parser.booleanValue();
            }
            parser.nextToken();
        }
        Index idx = new Index(index, "unknown");
        if (closed) {
            return new CloseIndexResponse.IndexResult(idx);
        }
        if (eex != null) {
            return new CloseIndexResponse.IndexResult(idx, eex);
        }
        if (!shardResults.isEmpty()) {
            return new CloseIndexResponse.IndexResult(idx, shardResults.toArray(new CloseIndexResponse.ShardResult[shardResults.size()]));
        }
        return new CloseIndexResponse.IndexResult(idx);
    }

    protected List<CloseIndexResponse.ShardResult> parseShardResults(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<CloseIndexResponse.ShardResult> list = new ArrayList<CloseIndexResponse.ShardResult>();
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                list.add(this.parseShardResult(parser, Integer.parseInt(fieldName)));
            }
            parser.nextToken();
        }
        return list;
    }

    protected CloseIndexResponse.ShardResult parseShardResult(XContentParser parser, int id) throws IOException {
        XContentParser.Token token;
        ArrayList<CloseIndexResponse.ShardResult.Failure> failures = new ArrayList<CloseIndexResponse.ShardResult.Failure>();
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_ARRAY && "failures".equals(fieldName)) {
                parser.nextToken();
                while ((token = parser.currentToken()) != XContentParser.Token.END_ARRAY) {
                    failures.add(this.parseFailure(parser));
                }
            }
            parser.nextToken();
        }
        return new CloseIndexResponse.ShardResult(id, failures.toArray(new CloseIndexResponse.ShardResult.Failure[failures.size()]));
    }

    protected CloseIndexResponse.ShardResult.Failure parseFailure(XContentParser parser) throws IOException {
        XContentParser.Token token;
        int shardId = -1;
        String index = null;
        OpenSearchException eex = null;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("reason".equals(fieldName)) {
                    parser.nextToken();
                    eex = OpenSearchException.fromXContent((XContentParser)parser);
                    parser.nextToken();
                }
            } else if (token == XContentParser.Token.VALUE_STRING) {
                if ("index".equals(fieldName)) {
                    index = parser.text();
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER && "shard".equals(fieldName)) {
                shardId = parser.intValue();
            }
            parser.nextToken();
        }
        return new CloseIndexResponse.ShardResult.Failure(index, shardId, eex);
    }
}

