/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexAction;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class HttpCreateIndexAction
extends HttpAction {
    protected static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    protected static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    protected static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    protected final CreateIndexAction action;

    public HttpCreateIndexAction(HttpClient client, CreateIndexAction action) {
        super(client);
        this.action = action;
    }

    public void execute(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener) {
        String source = null;
        try (XContentBuilder builder = this.toXContent(request, JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS);){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                CreateIndexResponse refreshResponse = CreateIndexResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)refreshResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected XContentBuilder toXContent(CreateIndexRequest request, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(request, builder, params);
        builder.endObject();
        return builder;
    }

    protected XContentBuilder innerToXContent(CreateIndexRequest request, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SETTINGS.getPreferredName());
        request.settings().toXContent(builder, params);
        builder.endObject();
        String mappingSource = request.mappings();
        if (mappingSource == null) {
            throw new UnsupportedOperationException("unknown mapping operation.");
        }
        try (XContentParser createParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map mappingMap = createParser.map();
            Object v = mappingMap.get("_doc");
            if (v instanceof Map) {
                Map map;
                mappingMap = map = (Map)v;
            }
            builder.startObject(MAPPINGS.getPreferredName());
            for (Map.Entry e : mappingMap.entrySet()) {
                builder.field((String)e.getKey(), e.getValue());
            }
            builder.endObject();
        }
        builder.startObject(ALIASES.getPreferredName());
        for (Alias alias : request.aliases()) {
            if (alias.writeIndex() == null) {
                alias.writeIndex(Boolean.valueOf(false));
            }
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    protected CurlRequest getCurlRequest(CreateIndexRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)PUT, "/", request.index());
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        if (!ActiveShardCount.DEFAULT.equals((Object)request.waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.waitForActiveShards())));
        }
        return curlRequest;
    }
}

